/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.java.snowflakes.entities.impl;

import br.com.brjdevs.java.snowflakes.entities.Config;
import br.com.brjdevs.java.snowflakes.entities.impl.ConfigImpl;

public class ConfigBuilder {
    private long datacenterIdBits;
    private long epoch;
    private long sequenceBits;
    private long workerIdBits;

    public Config build() {
        return new ConfigImpl(this.epoch, this.datacenterIdBits, this.workerIdBits, this.sequenceBits);
    }

    public ConfigBuilder datacenterIdBits(long datacenterIdBits) {
        if (datacenterIdBits < 0L) {
            throw new IllegalArgumentException("datacenterIdBits must be positive");
        }
        if (datacenterIdBits + this.workerIdBits + this.sequenceBits >= 64L) {
            throw new IllegalArgumentException("(datacenterIdBits + workerIdBits + sequenceBits) need to be under 64 bits.");
        }
        this.datacenterIdBits = datacenterIdBits;
        return this;
    }

    public ConfigBuilder epoch(long epoch) {
        if (epoch < 0L) {
            throw new IllegalArgumentException("epoch must be positive");
        }
        if (epoch > System.currentTimeMillis()) {
            throw new IllegalArgumentException("epoch is on the future");
        }
        this.epoch = epoch;
        return this;
    }

    public ConfigBuilder sequenceBits(long sequenceBits) {
        if (sequenceBits < 0L) {
            throw new IllegalArgumentException("sequenceBits must be positive");
        }
        if (this.datacenterIdBits + this.workerIdBits + sequenceBits >= 64L) {
            throw new IllegalArgumentException("(datacenterIdBits + workerIdBits + sequenceBits) need to be under 64 bits.");
        }
        this.sequenceBits = sequenceBits;
        return this;
    }

    public ConfigBuilder workerIdBits(long workerIdBits) {
        if (workerIdBits < 0L) {
            throw new IllegalArgumentException("workerIdBits must be positive");
        }
        if (this.datacenterIdBits + workerIdBits + this.sequenceBits >= 64L) {
            throw new IllegalArgumentException("(datacenterIdBits + workerIdBits + sequenceBits) need to be under 64 bits.");
        }
        this.workerIdBits = workerIdBits;
        return this;
    }
}

