package br.com.brjdevs.java.snowflakes.snow64;

import java.util.Base64;

/**
 * <b>Snow64</b> is a variant of a Snowflake
 */
public class Snow64Converter {
	public static String toSnow64(long snowflake) {
		return Base64.getEncoder().encodeToString(toByteArray(snowflake))
			.replace('/', '-')
			.replace('=', ' ')
			.trim();
	}

	public static long toSnowflake(String snow64) {
		return fromByteArray(
			Base64.getDecoder().decode(
				snow64.replace('-', '/')
			)
		);
	}

	/*
	Copied and flattened from class com.google.common.primitives.Longs (Guava)
	 */
	private static long fromByteArray(byte[] bytes) {
		if (bytes.length < Long.BYTES) throw new IllegalArgumentException(
			"array too small: " + bytes.length + " < " + Long.BYTES
		);

		return (bytes[0] & 0xFFL) << 56 | (bytes[1] & 0xFFL) << 48 | (bytes[2] & 0xFFL) << 40
			| (bytes[3] & 0xFFL) << 32 | (bytes[4] & 0xFFL) << 24 | (bytes[5] & 0xFFL) << 16
			| (bytes[6] & 0xFFL) << 8 | (bytes[7] & 0xFFL);
	}

	/*
	Copied and flattened from class com.google.common.primitives.Longs (Guava)
	 */
	private static byte[] toByteArray(long value) {
		byte[] result = new byte[8];
		for (int i = 7; i >= 0; i--) {
			result[i] = (byte) (value & 0xffL);
			value >>= 8;
		}
		return result;
	}
}