package br.com.brjdevs.java.snowflakes.entities.impl;

import br.com.brjdevs.java.snowflakes.entities.Config;

public class ConfigBuilder {
	private long datacenterIdBits;
	private long epoch;
	private long sequenceBits;
	private long workerIdBits;

	public Config build() {
		return new ConfigImpl(epoch, datacenterIdBits, workerIdBits, sequenceBits);
	}

	public ConfigBuilder datacenterIdBits(long datacenterIdBits) {
		if (datacenterIdBits < 0) throw new IllegalArgumentException("datacenterIdBits must be positive");
		if ((datacenterIdBits + workerIdBits + sequenceBits) >= Long.SIZE)
			throw new IllegalArgumentException("(datacenterIdBits + workerIdBits + sequenceBits) need to be under " + Long.SIZE + " bits.");

		this.datacenterIdBits = datacenterIdBits;
		return this;
	}

	public ConfigBuilder epoch(long epoch) {
		if (epoch < 0) throw new IllegalArgumentException("epoch must be positive");
		if (epoch > System.currentTimeMillis()) throw new IllegalArgumentException("epoch is on the future");

		this.epoch = epoch;
		return this;
	}

	public ConfigBuilder sequenceBits(long sequenceBits) {
		if (sequenceBits < 0) throw new IllegalArgumentException("sequenceBits must be positive");
		if ((datacenterIdBits + workerIdBits + sequenceBits) >= Long.SIZE)
			throw new IllegalArgumentException("(datacenterIdBits + workerIdBits + sequenceBits) need to be under " + Long.SIZE + " bits.");

		this.sequenceBits = sequenceBits;
		return this;
	}

	public ConfigBuilder workerIdBits(long workerIdBits) {
		if (workerIdBits < 0) throw new IllegalArgumentException("workerIdBits must be positive");
		if ((datacenterIdBits + workerIdBits + sequenceBits) >= Long.SIZE)
			throw new IllegalArgumentException("(datacenterIdBits + workerIdBits + sequenceBits) need to be under " + Long.SIZE + " bits.");

		this.workerIdBits = workerIdBits;
		return this;
	}
}
