package br.com.brjdevs.java.snowflakes.entities;

import java.time.OffsetDateTime;

public interface Config {
	OffsetDateTime creationTime(long snowflake);

	long creationTimeMillis(long snowflake);

	Datacenter datacenter(long datacenterId);

	long datacenterBits();

	long epoch();

	/**
	 * Returns the day that this config set-up can't generate Snowflakes anymore due to it overflowing the {@link Bits#TIMESTAMP} bits.
	 *
	 * @return a {@link OffsetDateTime} of when it will happen.
	 */
	OffsetDateTime expirationDate();

	/**
	 * Returns the day that this config set-up can't generate Snowflakes anymore due to it overflowing the {@link Bits#TIMESTAMP} bits.
	 *
	 * @return the epoch of when it will happen.
	 */
	long expirationDateMillis();

	long sequenceBits();

	/**
	 * Gives how much time until this config expire.
	 *
	 * @return the time in milliseconds.
	 */
	long timeRemaining();

	long timestampBits();

	/**
	 * Returns if this config can still generate Snowflakes.
	 *
	 * @return
	 */
	boolean valid();

	Worker worker(long datacenterId, long workerId);

	long workerBits();
}
