package br.com.brjdevs.java.snowflakes;

import br.com.brjdevs.java.snowflakes.entities.Config;

import java.time.OffsetDateTime;

/**
 * Marks a snowflake entity. Snowflake entities are ones that have an id that uniquely identifies them.
 * <br>(Yes, this Interface was blalantly copied from JDA)
 */
public interface ISnowflake {

	/**
	 * The Snowflake id of this entity. This is unique to every entity and will never change.
	 *
	 * @return long containing the Id.
	 */
	long getId();

	/**
	 * The Setup that made this Snowflake. Can be customized to reflect the value on {@link #getCreationTime}
	 *
	 * @return an Snowflake {@link Config}.
	 */
	Config getSetup();

	/**
	 * The time this entity was created. Calculated through the Snowflake in {@link #getId}.
	 *
	 * @return OffsetDateTime - Time this entity was created at.
	 */
	default OffsetDateTime getCreationTime() {
		return getSetup().creationTime(getId());
	}
}