/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.network.factory;

public abstract class PacketFactory<T> {
    public final int id;
    public final Class<T> type;

    public PacketFactory(Class<T> type, int id) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.type = type;
        this.id = id;
    }

    public abstract byte[] serialize(T var1);

    public abstract T unserialize(byte[] var1);

    public boolean equals(Object other) {
        if (other instanceof PacketFactory) {
            PacketFactory f = (PacketFactory)other;
            return f.type.equals(this.type) && f.id == this.id;
        }
        return false;
    }

    public String toString() {
        return "PacketFactory{id[" + this.id + "], type[" + this.type.getName() + "]}";
    }
}

