/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.network.factory;

import br.com.brjdevs.network.factory.PacketFactory;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class KryoPacketFactory<T>
extends PacketFactory<T> {
    private final transient Kryo kryo;

    public KryoPacketFactory(Class<T> type, int id, Kryo kryo) {
        super(type, id);
        this.kryo = kryo;
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
    }

    public KryoPacketFactory(Class<T> type, int id) {
        this(type, id, new Kryo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] serialize(T packet) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Output out = new Output((OutputStream)baos);
        Kryo kryo = this.kryo;
        synchronized (kryo) {
            this.kryo.writeClassAndObject(out, packet);
        }
        out.close();
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T unserialize(byte[] data) {
        Object packet;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        Input i = new Input((InputStream)bais);
        Kryo kryo = this.kryo;
        synchronized (kryo) {
            packet = this.kryo.readClassAndObject(i);
        }
        i.close();
        return (T)packet;
    }

    @Override
    public String toString() {
        return "KryoPacketFactory{id[" + this.id + "], type[" + this.type.getName() + "]}";
    }
}

