/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.network;

import br.com.brjdevs.network.AbstractServer;
import br.com.brjdevs.network.Connection;
import br.com.brjdevs.network.JSONPacket;
import br.com.brjdevs.network.PacketRegistry;
import br.com.brjdevs.network.SocketListener;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;

public class Server
extends AbstractServer
implements Connection {
    private final Map<Integer, WebSocket> connections = new ConcurrentHashMap<Integer, WebSocket>();
    private final SocketListener listener;

    public Server(InetSocketAddress address, PacketRegistry pr, SocketListener listener) {
        super(address, pr);
        this.listener = listener;
        pr.register(JSONPacket.FACTORY);
        pr.lock();
    }

    public Server(InetSocketAddress address, SocketListener listener) {
        this(address, new PacketRegistry(), listener);
    }

    @Override
    public void close(int client) {
        this.getConnection(client).close();
    }

    @Override
    public WebSocket getSocket(int client) {
        return this.getConnection(client);
    }

    @Override
    public Connection.Type getType() {
        return Connection.Type.SERVER;
    }

    @Override
    public boolean isConnected(int client) {
        return this.connections.containsKey(client);
    }

    @Override
    public void reconnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final void connectionOpened(WebSocket socket, ClientHandshake handshake) {
        int id = 0;
        while (this.connections.containsKey(id)) {
            ++id;
        }
        this.connections.put(id, socket);
        this.listener.onConnect(this, id, socket);
    }

    @Override
    public final void onPacket(WebSocket sender, Object packet) {
        Object o = this.listener.onPacket(this, this.getId(sender), packet);
        if (o == null) {
            return;
        }
        this.sendPacket(sender, o);
    }

    public final void onClose(WebSocket p1, int p2, String p3, boolean p4) {
        int id = this.getId(p1);
        this.listener.onClose(this, id, p2, p3);
        this.connections.remove(id);
    }

    public final void onError(WebSocket p1, Exception p2) {
        if (!this.connections.containsValue(p1)) {
            this.listener.onError(this, -1, p2);
        } else {
            this.listener.onError(this, this.getId(p1), p2);
        }
    }

    public final int[] getClients() {
        return Arrays.stream(this.connections.keySet().toArray(new Integer[0])).mapToInt(Integer::intValue).toArray();
    }

    private WebSocket getConnection(int id) {
        WebSocket s = this.connections.get(id);
        if (s == null) {
            throw new IllegalArgumentException("No connection for id " + id);
        }
        return s;
    }

    private int getId(WebSocket socket) {
        for (Map.Entry<Integer, WebSocket> entry : this.connections.entrySet()) {
            if (!entry.getValue().equals(socket)) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("Unknown socket");
    }
}

