/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.network;

import br.com.brjdevs.network.AbstractClient;
import br.com.brjdevs.network.Connection;
import br.com.brjdevs.network.JSONPacket;
import br.com.brjdevs.network.PacketRegistry;
import br.com.brjdevs.network.PacketRegistryAcceptedPacket;
import br.com.brjdevs.network.SocketListener;
import java.net.URI;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ServerHandshake;

public class Client
implements Connection {
    private final SocketListener listener;
    private final PacketRegistry registry;
    private final URI uri;
    private volatile Socket connection;

    public Client(URI uri, PacketRegistry registry, SocketListener listener) {
        this.uri = uri;
        this.registry = registry;
        this.listener = listener;
        registry.register(PacketRegistryAcceptedPacket.FACTORY);
        registry.register(JSONPacket.FACTORY);
        registry.lock();
        this.connection = new Socket(uri, registry, listener, this);
    }

    public Client(URI uri, SocketListener listener) {
        this(uri, new PacketRegistry(), listener);
    }

    @Override
    public void close(int ignored) {
        try {
            this.connection.closeBlocking();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public WebSocket getSocket(int client) {
        return this.connection.getConnection();
    }

    @Override
    public Connection.Type getType() {
        return Connection.Type.CLIENT;
    }

    @Override
    public boolean isConnected(int ignored) {
        return this.connection.getConnection().isOpen();
    }

    @Override
    public void reconnect() {
        if (this.connection.getConnection().isOpen()) {
            try {
                this.connection.closeBlocking();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.connection = new Socket(this.uri, this.registry, this.listener, this);
        try {
            this.connection.connectBlocking();
            this.connection.waitForValidation();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public AbstractClient getPacketClient() {
        return this.connection;
    }

    private static class Socket
    extends AbstractClient {
        private final Client client;
        private final SocketListener listener;

        public Socket(URI uri, PacketRegistry registry, SocketListener listener, Client client) {
            super(uri, registry, true);
            this.listener = listener;
            this.client = client;
        }

        @Override
        protected void connectionOpened(ServerHandshake handshake) {
            this.listener.onConnect(this.client, 0, this.getConnection());
        }

        @Override
        public void onPacket(Object packet) {
            Object o = this.listener.onPacket(this.client, 0, packet);
            if (o == null) {
                return;
            }
            this.sendPacket(o);
        }

        public void onClose(int p1, String p2, boolean p3) {
            this.listener.onClose(this.client, 0, p1, p2);
        }

        public void onError(Exception p1) {
            this.listener.onError(this.client, 0, p1);
        }
    }
}

