/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.network;

import br.com.brjdevs.network.PacketRegistry;
import br.com.brjdevs.network.PacketRegistryAcceptedPacket;
import br.com.brjdevs.network.PacketRegistryValidationPacket;
import java.net.URI;
import java.nio.ByteBuffer;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public abstract class AbstractClient
extends WebSocketClient {
    private final PacketRegistry registry;
    private volatile boolean closed = false;
    private volatile transient Object lastPacket;
    private volatile boolean validated = false;

    public AbstractClient(URI uri, PacketRegistry registry) {
        this(uri, registry, false);
    }

    public AbstractClient(URI uri, PacketRegistry registry, boolean reusedRegistry) {
        super(uri);
        this.registry = registry;
        if (!reusedRegistry) {
            registry.register(PacketRegistryAcceptedPacket.FACTORY);
        }
    }

    protected abstract void connectionOpened(ServerHandshake var1);

    public abstract void onPacket(Object var1);

    public void onCloseInitiated(int code, String reason) {
        this.closed = true;
    }

    public final void onOpen(ServerHandshake p1) {
        this.send(PacketRegistryValidationPacket.FACTORY.serialize(new PacketRegistryValidationPacket(this.registry)));
        this.connectionOpened(p1);
    }

    public final void onMessage(String p1) {
    }

    public final void onMessage(ByteBuffer bytes) {
        Object packet = this.registry.readPacket(bytes.array());
        if (packet instanceof PacketRegistryAcceptedPacket) {
            this.validated = true;
        }
        this.lastPacket = packet;
        this.onPacket(this.lastPacket);
    }

    public final <T> T readPacketBlocking(Class<T> packetClass) {
        return this.readPacketBlocking(packetClass, false);
    }

    public final <T> T readPacketBlocking(Class<T> packetClass, boolean exact) {
        Object packet = this.readPacketBlocking();
        if (exact) {
            while (packetClass != packet.getClass()) {
                packet = this.readPacketBlocking();
            }
            return (T)packet;
        }
        while (!packetClass.isInstance(packet)) {
            packet = this.readPacketBlocking();
        }
        return (T)packet;
    }

    public final Object readPacketBlocking() {
        Object o = this.lastPacket;
        while (o == this.lastPacket) {
        }
        return this.lastPacket;
    }

    public final void sendPacket(Object packet) {
        if (!this.validated) {
            return;
        }
        this.send(this.registry.writePacket(packet));
    }

    public final void waitForValidation() {
        while (!this.validated) {
            if (!this.closed) continue;
            throw new IllegalStateException("Connection closed");
        }
    }
}

