package br.com.brjdevs.network.factory;

public abstract class PacketFactory<T> {
	public final int id;
	public final Class<T> type;

	public PacketFactory(Class<T> type, int id) {
		if (type == null) throw new NullPointerException("type");
		this.type = type;
		this.id = id;
	}

	public abstract byte[] serialize(T packet);

	public abstract T unserialize(byte[] data);

	@Override
	public boolean equals(Object other) {
		if (other instanceof PacketFactory) {
			PacketFactory f = (PacketFactory) other;
			return f.type.equals(type) && f.id == id;
		}
		return false;
	}

	@Override
	public String toString() {
		return "PacketFactory{id[" + id + "], type[" + type.getName() + "]}";
	}
}
