package br.com.brjdevs.network.factory;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.io.UnsafeInput;
import com.esotericsoftware.kryo.io.UnsafeOutput;
import org.objenesis.strategy.StdInstantiatorStrategy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class KryoUnsafePacketFactory<T> extends KryoPacketFactory<T> {
	private final transient Kryo kryo;

	public KryoUnsafePacketFactory(Class<T> type, int id, Kryo kryo) {
		super(type, id);
		this.kryo = kryo;
		kryo.setInstantiatorStrategy(new Kryo.DefaultInstantiatorStrategy(new StdInstantiatorStrategy()));
	}

	public KryoUnsafePacketFactory(Class<T> type, int id) {
		this(type, id, new Kryo());
	}

	@Override
	public byte[] serialize(T packet) {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		Output out = new UnsafeOutput(baos);
		kryo.writeClassAndObject(out, packet);
		out.close();
		return baos.toByteArray();
	}

	@SuppressWarnings("unchecked")
	@Override
	public T unserialize(byte[] data) {
		Input in = new UnsafeInput(new ByteArrayInputStream(data));
		T t = (T) kryo.readClassAndObject(in);
		in.close();
		return t;
	}

	@Override
	public String toString() {
		return "KryoUnsafePacketFactory{id[" + id + "], type[" + type.getName() + "]}";
	}
}
