package br.com.brjdevs.network;

import br.com.brjdevs.network.factory.KryoPacketFactory;
import br.com.brjdevs.network.factory.PacketFactory;
import com.esotericsoftware.kryo.Kryo;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONPacket {
	public static final PacketFactory<JSONPacket> FACTORY;

	static {
		Kryo kryo = new Kryo();
		kryo.register(String.class);
		FACTORY = new KryoPacketFactory<>(JSONPacket.class, 1);
	}

	public final String json;

	public JSONPacket(String json) {
		this.json = json;
		try {
			new JSONObject(json);
		} catch (JSONException ex) {
			throw new IllegalArgumentException("Not a valid JSON object");
		}
	}

	@Override
	public boolean equals(Object other) {
		return other instanceof JSONPacket && ((JSONPacket) other).json.equals(json);
	}

	@Override
	public String toString() {
		return json;
	}

	public JSONObject getJSON() {
		try {
			return new JSONObject(json);
		} catch (JSONException e) {
			throw new InternalError("Impossible");
		}
	}
}
