/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.network.factory;

import br.com.brjdevs.network.factory.KryoPacketFactory;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.io.UnsafeInput;
import com.esotericsoftware.kryo.io.UnsafeOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class KryoUnsafePacketFactory<T>
extends KryoPacketFactory<T> {
    private final transient Kryo kryo;

    public KryoUnsafePacketFactory(Class<T> type, int id, Kryo kryo) {
        super(type, id);
        this.kryo = kryo;
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
    }

    public KryoUnsafePacketFactory(Class<T> type, int id) {
        this(type, id, new Kryo());
    }

    @Override
    public byte[] serialize(T packet) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        UnsafeOutput out = new UnsafeOutput((OutputStream)baos);
        this.kryo.writeClassAndObject((Output)out, packet);
        out.close();
        return baos.toByteArray();
    }

    @Override
    public T unserialize(byte[] data) {
        UnsafeInput in = new UnsafeInput((InputStream)new ByteArrayInputStream(data));
        Object t = this.kryo.readClassAndObject((Input)in);
        in.close();
        return (T)t;
    }

    @Override
    public String toString() {
        return "KryoUnsafePacketFactory{id[" + this.id + "], type[" + this.type.getName() + "]}";
    }
}

