/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.network;

import br.com.brjdevs.network.PacketRegistry;
import br.com.brjdevs.network.PacketRegistryAcceptedPacket;
import br.com.brjdevs.network.PacketRegistryValidationPacket;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;

public abstract class AbstractServer
extends WebSocketServer {
    private final PacketRegistry registry;
    private final List<WebSocket> socketsWaitingForApproval = new CopyOnWriteArrayList<WebSocket>();

    public AbstractServer(InetSocketAddress address, PacketRegistry registry) {
        super(address);
        this.registry = registry;
        registry.register(PacketRegistryAcceptedPacket.FACTORY);
    }

    protected abstract void connectionOpened(WebSocket var1, ClientHandshake var2);

    public abstract void onPacket(WebSocket var1, Object var2);

    public final void onOpen(WebSocket p1, ClientHandshake p2) {
        this.socketsWaitingForApproval.add(p1);
        this.connectionOpened(p1, p2);
    }

    public final void onMessage(WebSocket conn, String message) {
    }

    public final void onMessage(WebSocket p1, ByteBuffer p2) {
        Object packet;
        byte[] data = p2.array();
        if (this.socketsWaitingForApproval.size() > 0 && this.socketsWaitingForApproval.remove(p1)) {
            try {
                PacketRegistryValidationPacket p = PacketRegistryValidationPacket.FACTORY.unserialize(data);
                if (!this.registry.equals(p.registry)) {
                    p1.close(1403, "PacketRegistry does not match");
                    return;
                }
            }
            catch (Exception e) {
                this.onError(p1, e);
                p1.close(1403, "PacketRegistryValidationPacket invalid");
                return;
            }
            p1.send(this.registry.writePacket(new PacketRegistryAcceptedPacket()));
        }
        try {
            packet = this.registry.readPacket(data);
        }
        catch (Exception e) {
            this.onError(p1, e);
            return;
        }
        this.onPacket(p1, packet);
    }

    public void sendPacket(WebSocket socket, Object packet) {
        socket.send(this.registry.writePacket(packet));
    }
}

