package br.com.brjdevs.network.factory;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.objenesis.strategy.StdInstantiatorStrategy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class KryoPacketFactory<T> extends PacketFactory<T> {
	private final transient Kryo kryo;

	public KryoPacketFactory(Class<T> type, int id, Kryo kryo) {
		super(type, id);
		this.kryo = kryo;
		kryo.setInstantiatorStrategy(new Kryo.DefaultInstantiatorStrategy(new StdInstantiatorStrategy()));
	}

	public KryoPacketFactory(Class<T> type, int id) {
		this(type, id, new Kryo());
	}

	@Override
	public byte[] serialize(T packet) {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		Output out = new Output(baos);
		synchronized (kryo) {
			kryo.writeClassAndObject(out, packet);
		}
		out.close();
		return baos.toByteArray();
	}

	@SuppressWarnings("unchecked")
	@Override
	public T unserialize(byte[] data) {
		ByteArrayInputStream bais = new ByteArrayInputStream(data);
		Input i = new Input(bais);
		T packet;
		synchronized (kryo) {
			packet = (T) kryo.readClassAndObject(i);
		}
		i.close();
		return packet;
	}

	@Override
	public String toString() {
		return "KryoPacketFactory{id[" + id + "], type[" + type.getName() + "]}";
	}
}
