/*
 * Decompiled with CFR 0.152.
 */
package br.com.brjdevs.highhacks.eventbus;

import br.com.brjdevs.highhacks.eventbus.ASMEventHandler;
import br.com.brjdevs.highhacks.eventbus.ASMEventHandlerConstructor;
import br.com.brjdevs.highhacks.eventbus.ASMEventHandlerHandle;
import br.com.brjdevs.highhacks.eventbus.EventHandler;
import br.com.brjdevs.highhacks.eventbus.Listener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.FixedValue;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ASMEventBus {
    private final ByteBuddy bb = new ByteBuddy();
    private final Map<Class<?>, List<Pair<Object, EventHandler>>> handlers;
    private final ClassLoader loader;
    private final boolean threadSafe;

    public ASMEventBus(ClassLoader loader, boolean threadSafe) {
        this.threadSafe = threadSafe;
        this.loader = loader;
        this.handlers = threadSafe ? new ConcurrentHashMap() : new HashMap();
    }

    public ASMEventBus(ClassLoader loader) {
        this(loader, false);
    }

    public ASMEventBus() {
        this(ASMEventBus.class.getClassLoader());
    }

    public void register(final Object listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (listener instanceof EventHandler) {
            if (listener instanceof ASMEventHandler) {
                ASMEventHandler asmeh = (ASMEventHandler)listener;
                this.getHandlers(asmeh.getEventClass()).add(new Pair(asmeh, asmeh));
                return;
            }
            this.getHandlers(Object.class).add(new Pair(listener, (EventHandler)listener));
            return;
        }
        final Class<?> listenerClass = listener.getClass();
        if (Modifier.isPublic(listenerClass.getModifiers())) {
            for (ASMEventHandler h : this.handlers(listener)) {
                this.getHandlers(h.getEventClass()).add(new Pair(listener, h));
            }
        } else {
            for (final Method m : listenerClass.getMethods()) {
                Listener list = m.getAnnotation(Listener.class);
                if (list == null) continue;
                Class<?>[] params = m.getParameterTypes();
                if (params.length != 1) {
                    throw new IllegalArgumentException(m + ": parameterTypes.length != 1: " + m.toGenericString());
                }
                final Class<?> evt = params[0];
                this.getHandlers(evt).add(new Pair(listener, new EventHandler(){

                    @Override
                    public void handle(Object event) {
                        if (evt.isInstance(event)) {
                            try {
                                m.invoke(listener, event);
                            }
                            catch (IllegalAccessException e) {
                                throw new AssertionError();
                            }
                            catch (InvocationTargetException e) {
                                Throwable cause = e.getCause();
                                if (cause instanceof Error) {
                                    throw (Error)cause;
                                }
                                if (cause instanceof RuntimeException) {
                                    throw (RuntimeException)cause;
                                }
                                throw new RuntimeException(cause);
                            }
                        }
                    }

                    public String toString() {
                        return "ReflectionEventHandler{" + this.getClass().getName() + " -> " + listenerClass.getName() + "}";
                    }
                }));
            }
        }
    }

    public void unregister(Object listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        for (List<Pair<Object, EventHandler>> list : this.handlers.values()) {
            ArrayList<Pair<Object, EventHandler>> toRemove = new ArrayList<Pair<Object, EventHandler>>();
            for (Pair<Object, EventHandler> pair : list) {
                if (((Pair)pair).left != listener) continue;
                toRemove.add(pair);
            }
            list.removeAll(toRemove);
        }
    }

    public void post(Object event) {
        for (Class<?> eventClass = event.getClass(); eventClass != Object.class; eventClass = eventClass.getSuperclass()) {
            for (Pair<Object, EventHandler> h : this.getHandlers(eventClass)) {
                EventHandler handler = (EventHandler)((Pair)h).right;
                handler.handle(event);
            }
        }
    }

    private ASMEventHandler[] handlers(Object listener) {
        Class<?> listenerClass = listener.getClass();
        Method[] _mtds = listenerClass.getMethods();
        class Holder {
            Method m;
            Class<?> c;

            Holder() {
            }
        }
        ArrayList<Holder> mtds = new ArrayList<Holder>();
        for (Method m : _mtds) {
            Listener list = m.getAnnotation(Listener.class);
            if (list == null) continue;
            Class<?>[] args = m.getParameterTypes();
            if (args.length != 1) {
                throw new IllegalArgumentException(m + ": parameterTypes.length != 1");
            }
            Class<?> arg = args[0];
            Holder h = new Holder();
            h.m = m;
            h.c = arg;
            mtds.add(h);
        }
        ASMEventHandler[] ret = new ASMEventHandler[mtds.size()];
        for (int i = 0; i < mtds.size(); ++i) {
            Holder h = (Holder)mtds.get(i);
            String name = listenerClass.getName() + "$1ASMEventHandler___" + h.m.getName() + "___" + h.c.getName().replace('.', '_').replace("$", "__");
            try {
                ret[i] = (ASMEventHandler)Class.forName(name, true, this.loader).getConstructor(Object.class).newInstance(listener);
                continue;
            }
            catch (ClassNotFoundException list) {
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
            try {
                boolean isStatic = Modifier.isStatic(h.m.getModifiers());
                DynamicType.Builder builder = this.bb.subclass(ASMEventHandler.class).name(name).modifiers(4105);
                if (!isStatic) {
                    builder = builder.defineField("instance", Object.class, new ModifierContributor.ForField[0]);
                }
                ret[i] = (ASMEventHandler)builder.defineConstructor(1).withParameters(new Type[]{Object.class}).intercept((Implementation)new ASMEventHandlerConstructor(name, isStatic)).method((ElementMatcher)ElementMatchers.named((String)"handle")).intercept((Implementation)new ASMEventHandlerHandle(name, listenerClass.getName(), h.c.getName(), h.m, isStatic)).method((ElementMatcher)ElementMatchers.named((String)"getEventClass")).intercept((Implementation)FixedValue.value(h.c)).method((ElementMatcher)ElementMatchers.named((String)"getTargetClass")).intercept((Implementation)FixedValue.value(listenerClass)).make().load(this.loader).getLoaded().getConstructor(Object.class).newInstance(listener);
                continue;
            }
            catch (Exception e) {
                throw new AssertionError("Error creating ASMEventHandler", e);
            }
        }
        return ret;
    }

    private List<Pair<Object, EventHandler>> getHandlers(Class<?> cls) {
        List<Pair<Object, EventHandler>> list = this.handlers.get(cls);
        if (list == null) {
            list = this.threadSafe ? new CopyOnWriteArrayList() : new ArrayList();
            this.handlers.put(cls, list);
        }
        return list;
    }

    private static class Pair<Left, Right> {
        private final Left left;
        private final Right right;

        private Pair(Left left, Right right) {
            this.left = left;
            this.right = right;
        }

        public boolean equals(Object other) {
            if (other instanceof Pair) {
                Pair p = (Pair)other;
                return Objects.equals(p.left, this.left) && Objects.equals(p.right, this.right);
            }
            return false;
        }
    }
}

