package br.com.braspag.cieloqrwallets.internal

import android.app.Dialog
import android.os.Bundle
import android.view.ContextThemeWrapper
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import androidx.annotation.StyleRes
import br.com.braspag.cieloqrwallets.UiMode
import com.google.android.material.bottomsheet.BottomSheetBehavior
import com.google.android.material.bottomsheet.BottomSheetDialog
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import kotlinx.android.synthetic.main.bottom_sheet_dialog.*
import android.content.Intent
import android.net.Uri
import android.widget.Toast
import br.com.braspag.cieloqrwallets.R
import com.google.android.gms.vision.barcode.Barcode
import com.google.android.gms.vision.barcode.BarcodeDetector
import android.graphics.BitmapFactory
import com.google.android.gms.vision.Frame

class CieloWalletFragment : BottomSheetDialogFragment() {

    private lateinit var cancelClickListener: () -> Unit
    private var qrCodeBase64: String? = null
    private var qrCodeId: String? = null

    @StyleRes
    private var currentTheme = R.style.LightTheme

    companion object {
        fun newInstance(
            qrCode: String?,
            qrCodeId: String?,
            theme: UiMode,
            onCancelListener: () -> Unit
        ): CieloWalletFragment =
            CieloWalletFragment().apply {
                cancelClickListener = onCancelListener
                qrCodeBase64 = qrCode
                this.qrCodeId = qrCodeId
                currentTheme = if (theme == UiMode.LIGHT) R.style.LightTheme else R.style.DarkTheme
            }
    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        val contextThemeWrapper = ContextThemeWrapper(activity, currentTheme)
        return inflater.cloneInContext(contextThemeWrapper).inflate(R.layout.bottom_sheet_dialog, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        btnCancel.setOnClickListener {
            cancelClickListener()
        }

        val detector = BarcodeDetector.Builder(context)
            .setBarcodeFormats(Barcode.ALL_FORMATS)
            .build()

        val decodedString = android.util.Base64.decode(qrCodeBase64, 0)

        val decodedByte = BitmapFactory.decodeByteArray(decodedString, 0, decodedString.size)

        val frame = Frame.Builder().setBitmap(decodedByte).build()

        val barcodes = detector.detect(frame)

        val path = barcodes.valueAt(0).rawValue

        imgIconPicPay.setOnClickListener{
            val intent = Intent(Intent.ACTION_VIEW)
            intent.data = Uri.parse("https://www.picpay.com.br/scanner/${path}")
            startActivity(intent)
        }

        imgIconCieloPay.setOnClickListener{
            Toast.makeText(view.context, "Em desenvolvimento...", Toast.LENGTH_LONG).show()
        }

        imgQRCode.setImageBitmap(decodedByte)
    }

    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {
        val dialog = super.onCreateDialog(savedInstanceState) as BottomSheetDialog

        dialog.setOnShowListener { dlg ->
            val d = dlg as BottomSheetDialog
            val bottomSheet = d.findViewById(com.google.android.material.R.id.design_bottom_sheet) as FrameLayout?
            bottomSheet?.let {
                BottomSheetBehavior.from(it).state = BottomSheetBehavior.STATE_EXPANDED
            }
        }
        return dialog
    }
}
