package br.com.braspag.cieloqrwallets

import android.content.Context
import androidx.fragment.app.FragmentActivity
import br.com.braspag.cieloqrwallets.internal.CieloWalletFragment

class CieloQRWallets(private val context: Context) {

    companion object {
        const val FRAGMENT_TAG = "cieloqr"
    }

    fun displayWallets(
        qrCodeBase64Image: String? = null,
        qrCodeId: String? = null,
        uiMode: UiMode = UiMode.LIGHT,
        onCancelListener: () -> Unit
    ) {
        val bottomFragment = CieloWalletFragment.newInstance(qrCodeBase64Image, qrCodeId, uiMode, onCancelListener)

        if (context is FragmentActivity) {
            bottomFragment.show(context.supportFragmentManager, FRAGMENT_TAG)
        } else {
            throw RuntimeException("Context must be a FragmentActivity!")
        }
    }
}