package com.br.base;

import android.databinding.DataBindingUtil;
import android.databinding.ViewDataBinding;
import android.os.Bundle;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.ViewGroup;

import java.lang.ref.WeakReference;

import butterknife.ButterKnife;

/**
 * Created by peterson on 23/02/17.
 */

public abstract class BaseBindFragment<M, V extends BaseView, P extends Presenter, B extends ViewDataBinding> extends Fragment {

    private Delegate<M, V, P> mvpDelegate =
            new Delegate<M, V, P>(createPresentationModelSerializer()) {
                @NonNull
                @Override
                protected P createPresenter() {
                    return BaseBindFragment.this.createPresenter();
                }

                @NonNull
                @Override
                protected M createPresentationModel() {
                    return BaseBindFragment.this.createPresentationModel();
                }
            };

    /***
     * Binding activity class generated by Android
     */
    public WeakReference<? extends ViewDataBinding> mBind;

    protected void putBind(B binding) {
        mBind = new WeakReference<>(binding);
    }

    protected B getBind() {
        return mBind == null ? null : (B) mBind.get();
    }

    /**
     * instance of FragmentManager
     */
    protected FragmentManager mFragmentManager;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mFragmentManager = getActivity().getSupportFragmentManager();
        mvpDelegate.onCreate(getLayoutId(), savedInstanceState);
    }

    @Nullable
    @Override
    public android.view.View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        putBind((B) DataBindingUtil.inflate(inflater, getLayoutId(), container, false));
        getBind().setVariable(data(), getPresenter().getPresentationModel());
        return getBind().getRoot();
    }

    @Override
    public void onStart() {
        super.onStart();
        mvpDelegate.onStart((V) this);
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        mvpDelegate.onSaveInstanceState(outState);
    }

    @Override
    public void onStop() {
        super.onStop();
        mvpDelegate.onStop();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        mvpDelegate.onDestroy();
    }

    /**
     * Feel free to override this method that returns your own implementation of
     * PresentationModelSerializer.
     * Useful if you use a Parceler library for example
     *
     * @return an instance of PresentationModelSerializer that will serialize and deserialize your
     * PresentationModel from Bundle.
     */
    protected PresentationModelSerializer<M> createPresentationModelSerializer() {
        return new ParcelableAndSerializablePresentationModelSerializer<>();
    }

    @NonNull
    protected P getPresenter() {
        return mvpDelegate.getPresenter();
    }

    /**
     * Used for creating the presenter instance, called in #onCreate(Bundle) method.
     *
     * @return an instance of your Presenter.
     */
    @NonNull
    protected abstract P createPresenter();

    /**
     * Used to create the Presentation Model that will be attached to your presenter in #onAttach()
     * method of your presenter.
     * <p>
     * NOTE: this will be called only if there is no Presentation Model persisted in your
     * savedInstanceState!
     * <p>
     * You can retrieve the arguments from #getArguments() method of your
     * fragment and pass it to your Presentation's model constructor.
     *
     * @return Presentation Model instance used by your Presenter.
     */
    @NonNull
    protected abstract M createPresentationModel();


    @Override
    public void onDestroyView() {
        super.onDestroyView();
        ButterKnife.unbind(this);
    }

    public abstract
    @LayoutRes
    int getLayoutId();


    /**
     * Replace content
     *
     * @param fragment       Component to replace
     * @param content        parent that will receive the fragment
     * @param tag            identifier fragment
     * @param addToBackStack flag to notify if fragment will added on back stack
     * @return true if replace content success of false
     */
    protected boolean replaceContent(Fragment fragment, final int content, String tag, boolean addToBackStack) {
        if (getActivity() instanceof BaseActivity) {
            ((BaseActivity) getActivity()).replaceContent(fragment, content, tag, addToBackStack);
            return true;
        } else {
            return false;
        }
    }

    /**
     * The int value found in the BR class generated by DataBinding
     *
     * @return
     */
    public abstract int data();

}
