/*
 * Decompiled with CFR 0.152.
 */
package br.com.autonomiccs.apacheCloudStack.client;

import br.com.autonomiccs.apacheCloudStack.client.ApacheCloudStackApiCommandParameter;
import br.com.autonomiccs.apacheCloudStack.client.ApacheCloudStackRequest;
import br.com.autonomiccs.apacheCloudStack.client.beans.ApacheCloudStackUser;
import br.com.autonomiccs.apacheCloudStack.exceptions.ApacheCloudStackClientRequestRuntimeException;
import br.com.autonomiccs.apacheCloudStack.exceptions.ApacheCloudStackClientRuntimeException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheCloudStackClient {
    protected boolean validateServerHttpsCertificate = true;
    private int requestValidity = 30;
    private int connectionTimeout = 60;
    private boolean shouldRequestsExpire = true;
    private Gson gson = new GsonBuilder().create();
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String url;
    protected ApacheCloudStackUser apacheCloudStackUser;

    public ApacheCloudStackClient(String url, ApacheCloudStackUser apacheCloudStackUser) {
        this.url = url;
        this.apacheCloudStackUser = apacheCloudStackUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeRequest(ApacheCloudStackRequest request) {
        boolean isSecretKeyApiKeyAuthenticationMechanism = StringUtils.isNotBlank((CharSequence)this.apacheCloudStackUser.getApiKey());
        String urlRequest = this.createApacheCloudStackApiUrlRequest(request, isSecretKeyApiKeyAuthenticationMechanism);
        this.logger.debug("Executing request[%s].", (Object)urlRequest);
        CloseableHttpClient httpClient = this.createHttpClient();
        HttpContext httpContext = this.createHttpContextWithAuthenticatedSessionUsingUserCredentialsIfNeeded(httpClient, isSecretKeyApiKeyAuthenticationMechanism);
        try {
            String string = this.executeRequestGetResponseAsString(urlRequest, httpClient, httpContext);
            return string;
        }
        finally {
            if (!isSecretKeyApiKeyAuthenticationMechanism) {
                this.executeUserLogout(httpClient, httpContext);
            }
            HttpClientUtils.closeQuietly((HttpClient)httpClient);
        }
    }

    protected String executeRequestGetResponseAsString(String urlRequest, CloseableHttpClient httpClient, HttpContext httpContext) {
        try {
            HttpGet httpGetRequest = new HttpGet(urlRequest);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGetRequest, httpContext);
            StatusLine requestStatus = response.getStatusLine();
            if (requestStatus.getStatusCode() == 200) {
                return this.getResponseAsString(response);
            }
            throw new ApacheCloudStackClientRequestRuntimeException(requestStatus.getStatusCode(), this.getResponseAsString(response), urlRequest.toString());
        }
        catch (IOException e) {
            this.logger.error(String.format("Error while executing request [%s]", urlRequest));
            throw new ApacheCloudStackClientRuntimeException(e);
        }
    }

    protected void executeUserLogout(CloseableHttpClient httpClient, HttpContext httpContext) {
        String urlRequest = this.createApacheCloudStackApiUrlRequest(new ApacheCloudStackRequest("logout").addParameter("response", "json"), false);
        String returnOfLogout = this.executeRequestGetResponseAsString(urlRequest, httpClient, httpContext);
        this.logger.debug("Logout result[%s]", (Object)returnOfLogout);
    }

    protected HttpContext createHttpContextWithAuthenticatedSessionUsingUserCredentialsIfNeeded(CloseableHttpClient httpClient, boolean isSecretKeyApiKeyAuthenticationMechanism) {
        if (isSecretKeyApiKeyAuthenticationMechanism) {
            return new BasicHttpContext();
        }
        return this.createHttpContextWithAuthenticatedSessionUsingUserCredentials(httpClient);
    }

    protected RequestConfig createRequestConfig() {
        return RequestConfig.custom().setConnectTimeout(this.connectionTimeout * 1000).setConnectionRequestTimeout(this.connectionTimeout * 1000).setSocketTimeout(this.connectionTimeout * 1000).build();
    }

    protected CloseableHttpClient createHttpClient() {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(this.createRequestConfig());
        if (!this.validateServerHttpsCertificate) {
            SSLConnectionSocketFactory sslsf = this.createInsecureSslFactory();
            httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        }
        return httpClientBuilder.build();
    }

    protected HttpContext createHttpContextWithAuthenticatedSessionUsingUserCredentials(CloseableHttpClient httpClient) {
        HttpPost httpPost = this.createHttpPost();
        List<NameValuePair> params = this.getParametersForLogin();
        try {
            UrlEncodedFormEntity postParams = new UrlEncodedFormEntity(params, "UTF-8");
            httpPost.setEntity((HttpEntity)postParams);
            CloseableHttpResponse loginResponse = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = loginResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new ApacheCloudStackClientRequestRuntimeException(statusCode, this.getResponseAsString(loginResponse), "login");
            }
            this.logger.debug("Authentication response:[%s]", (Object)this.getResponseAsString(loginResponse));
            return this.createHttpContextWithCookies(loginResponse);
        }
        catch (IOException e) {
            throw new ApacheCloudStackClientRuntimeException(e);
        }
    }

    protected HttpContext createHttpContextWithCookies(CloseableHttpResponse loginResponse) {
        BasicCookieStore cookieStore = new BasicCookieStore();
        this.createAndAddCookiesOnStoreForHeaders((CookieStore)cookieStore, loginResponse.getAllHeaders());
        BasicHttpContext httpContext = new BasicHttpContext();
        httpContext.setAttribute("http.cookie-store", (Object)cookieStore);
        return httpContext;
    }

    protected void createAndAddCookiesOnStoreForHeaders(CookieStore cookieStore, Header[] allHeaders) {
        for (Header header : allHeaders) {
            if (!StringUtils.startsWithIgnoreCase((CharSequence)header.getName(), (CharSequence)"Set-Cookie")) continue;
            this.createAndAddCookiesOnStoreForHeader(cookieStore, header);
        }
    }

    protected void createAndAddCookiesOnStoreForHeader(CookieStore cookieStore, Header header) {
        for (HeaderElement element : header.getElements()) {
            BasicClientCookie cookie = this.createCookieForHeaderElement(element);
            cookieStore.addCookie((Cookie)cookie);
        }
    }

    protected BasicClientCookie createCookieForHeaderElement(HeaderElement element) {
        BasicClientCookie cookie = new BasicClientCookie(element.getName(), element.getValue());
        for (NameValuePair parameter : element.getParameters()) {
            cookie.setAttribute(parameter.getName(), parameter.getValue());
        }
        cookie.setPath("/client/api");
        this.configureDomainForCookie(cookie);
        return cookie;
    }

    protected void configureDomainForCookie(BasicClientCookie cookie) {
        try {
            HttpHost httpHost = URIUtils.extractHost((URI)new URI(this.url));
            String domain = httpHost.getHostName();
            cookie.setDomain(domain);
        }
        catch (URISyntaxException e) {
            throw new ApacheCloudStackClientRuntimeException(e);
        }
    }

    protected HttpPost createHttpPost() {
        HttpPost httpPost = new HttpPost(this.url);
        httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
        return httpPost;
    }

    protected List<NameValuePair> getParametersForLogin() {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(4);
        params.add((NameValuePair)new BasicNameValuePair("command", "login"));
        params.add((NameValuePair)new BasicNameValuePair("username", this.apacheCloudStackUser.getUsername()));
        params.add((NameValuePair)new BasicNameValuePair("password", this.apacheCloudStackUser.getPassword()));
        params.add((NameValuePair)new BasicNameValuePair("domain", this.apacheCloudStackUser.getDomain()));
        return params;
    }

    protected SSLConnectionSocketFactory createInsecureSslFactory() {
        SSLContextBuilder builder = new SSLContextBuilder();
        try {
            builder.loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy());
            return new SSLConnectionSocketFactory(builder.build());
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new ApacheCloudStackClientRuntimeException(e);
        }
    }

    protected String getResponseAsString(CloseableHttpResponse response) throws IOException {
        InputStream responseContent = response.getEntity().getContent();
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)responseContent, (Writer)writer, (Charset)Charset.defaultCharset());
        responseContent.close();
        response.close();
        return writer.toString();
    }

    protected String createApacheCloudStackApiUrlRequest(ApacheCloudStackRequest request, boolean shouldSignAppendSignature) {
        StringBuilder urlRequest = new StringBuilder(this.url).append("?");
        String queryString = this.createCommandString(request);
        urlRequest.append(queryString);
        if (shouldSignAppendSignature) {
            String signature = this.createSignature(queryString);
            urlRequest.append("&signature=").append(this.getUrlEncodedValue(signature));
        }
        return urlRequest.toString();
    }

    protected String createSignature(String queryString) {
        byte[] signatureBytes = HmacUtils.hmacSha1((String)this.apacheCloudStackUser.getSecretKey(), (String)queryString.toLowerCase());
        return Base64.encodeBase64String((byte[])signatureBytes);
    }

    protected String createCommandString(ApacheCloudStackRequest request) {
        List<ApacheCloudStackApiCommandParameter> queryCommand = this.createSortedCommandQueryList(request);
        StringBuilder commandString = new StringBuilder();
        for (ApacheCloudStackApiCommandParameter param : queryCommand) {
            String value = this.getUrlEncodedValue(param.getValue());
            commandString.append(String.format("%s=%s&", param.getName(), value));
        }
        return commandString.toString().substring(0, commandString.length() - 1);
    }

    protected String getUrlEncodedValue(Object paramValue) {
        String value = Objects.toString(paramValue);
        try {
            value = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ApacheCloudStackClientRuntimeException(e);
        }
        return value.replaceAll("\\+", "%20");
    }

    protected List<ApacheCloudStackApiCommandParameter> createSortedCommandQueryList(ApacheCloudStackRequest request) {
        ArrayList<ApacheCloudStackApiCommandParameter> queryCommand = new ArrayList<ApacheCloudStackApiCommandParameter>();
        queryCommand.addAll(request.getParameters());
        queryCommand.add(new ApacheCloudStackApiCommandParameter("command", request.getCommand()));
        if (StringUtils.isNotBlank((CharSequence)this.apacheCloudStackUser.getApiKey())) {
            queryCommand.add(new ApacheCloudStackApiCommandParameter("apiKey", this.apacheCloudStackUser.getApiKey()));
        }
        this.configureRequestExpiration(queryCommand);
        Collections.sort(queryCommand);
        return queryCommand;
    }

    protected void configureRequestExpiration(List<ApacheCloudStackApiCommandParameter> apacheCloudStackRequestList) {
        boolean isOverridingExpirationConfigs = apacheCloudStackRequestList.contains(new ApacheCloudStackApiCommandParameter("expires", ""));
        if (!isOverridingExpirationConfigs && !this.shouldRequestsExpire) {
            return;
        }
        apacheCloudStackRequestList.add(new ApacheCloudStackApiCommandParameter("signatureVersion", 3));
        if (isOverridingExpirationConfigs) {
            return;
        }
        String expirationDataAsSring = this.createExpirationDate();
        apacheCloudStackRequestList.add(new ApacheCloudStackApiCommandParameter("expires", expirationDataAsSring));
    }

    protected String createExpirationDate() {
        SimpleDateFormat acsIso8601DateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        return acsIso8601DateFormat.format(this.getExpirationDate());
    }

    protected Date getExpirationDate() {
        Calendar now = Calendar.getInstance();
        now.add(13, this.requestValidity);
        return now.getTime();
    }

    public <T> T executeRequest(ApacheCloudStackRequest request, Class<T> clazz) {
        request.addParameter("response", "json");
        String response = this.executeRequest(request);
        return (T)this.gson.fromJson(response, clazz);
    }

    public void setValidateServerHttpsCertificate(boolean validateServerHttpsCertificate) {
        this.validateServerHttpsCertificate = validateServerHttpsCertificate;
    }

    public void setRequestValidity(int requestValidity) {
        this.requestValidity = requestValidity;
    }

    public void setShouldRequestsExpire(boolean shouldRequestsExpire) {
        this.shouldRequestsExpire = shouldRequestsExpire;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }
}

