/*
 * Decompiled with CFR 0.152.
 */
package br.com.arsmachina.tapestry_rss.pages;

import br.com.arsmachina.tapestry_rss.Channel;
import br.com.arsmachina.tapestry_rss.Item;
import br.com.arsmachina.tapestry_rss.services.ChannelProvider;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.ContentType;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.HttpError;

@ContentType(value="application/rss+xml")
public class Rss {
    @Inject
    private ChannelProvider channelProvider;
    @Inject
    private Messages messages;
    private Channel channel;

    Object onActivate(EventContext context) {
        this.channel = this.channelProvider.getChannel(context);
        return this.channel != null ? null : new HttpError(404, this.messages.get("tapestry-rss.error-404"));
    }

    boolean beginRender(MarkupWriter writer) {
        writer.element("rss", new Object[]{"version", "2.0", "xmlns:atom", "http://www.w3.org/2005/Atom"});
        writer.element("channel", new Object[0]);
        this.write(writer, "title", this.channel.getTitle());
        this.write(writer, "link", this.channel.getLink());
        this.write(writer, "description", this.channel.getDescription());
        writer.element("atom:link", new Object[]{"href", this.channel.getLink(), "rel", "self", "type", "application/rss+xml"});
        writer.end();
        for (Item item : this.channel.getItems()) {
            writer.element("item", new Object[0]);
            this.write(writer, "title", item.getTitle());
            this.write(writer, "description", item.getDescription());
            this.write(writer, "author", item.getAuthor());
            this.write(writer, "pubDate", item.getPublicationDate());
            this.write(writer, "link", item.getLink());
            this.write(writer, "guid", item.getGuid());
            writer.end();
        }
        writer.end();
        writer.end();
        return false;
    }

    private void write(MarkupWriter writer, String elementName, String content) {
        if (content != null) {
            writer.element(elementName, new Object[0]).text(content);
            writer.end();
        }
    }

    private void write(MarkupWriter writer, String elementName, Date date) {
        if (date != null) {
            this.write(writer, elementName, new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z").format(date));
        }
    }
}

