/*
 * Copyright 2016 Anteros Tecnologia
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package br.com.anteros.android.persistence.sql.jdbc;


import br.com.anteros.core.log.Logger;
import br.com.anteros.core.log.LoggerProvider;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public class SQLiteHelper extends SQLiteOpenHelper {
	
	Logger log = LoggerProvider.getInstance().getLogger(SQLiteHelper.class);

	private String databaseName;
	private Context context;

	public SQLiteHelper(Context context, String databaseName) {
		super(context, databaseName, null, 1);
		this.context = context;
		this.databaseName = databaseName;
	}

	public String getDatabaseName() {
		return databaseName;
	}

	@Override
	public void onCreate(SQLiteDatabase db) {
	}

	@Override
	public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
	}

	public void dropAndCreateTables() throws Exception {
		close();
		context.deleteDatabase(databaseName);
		onCreate(this.getWritableDatabase());
	}

	protected void close(Cursor cursor) throws Exception {
		if (cursor != null) {
			cursor.close();
		}
	}
	
	@Override
	public void onOpen(SQLiteDatabase db) {
	    super.onOpen(db);
	    if (!db.isReadOnly()) {
	        /*
	         *  Habilita o uso de chaves estrangeiras
	         */
	        //db.execSQL("PRAGMA foreign_keys=ON;");
	    }
	}

}
