/*
 * Copyright 2016 Anteros Tecnologia
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package br.com.anteros.android.core.communication.ws;

/**
 * Created by edson on 21/05/16.
 */

import java.util.Hashtable;

import org.ksoap2.serialization.PropertyInfo;
import org.ksoap2.serialization.SoapObject;

public final class EnderecoCorreio extends SoapObject {
    private java.lang.String bairro;

    private java.lang.String cep;

    private java.lang.String cidade;

    private java.lang.String complemento;

    private java.lang.String complemento2;

    private java.lang.String end;

    private long id;

    private java.lang.String uf;

    private UnidadePostagem[] unidadesPostagem;

    private EnderecoCorreio() {
        super("", "");
    }

    public EnderecoCorreio(SoapObject response) {
        int len = response.getPropertyCount();
        for (int i = 0; i < len; i++) {
            this.setProperty(i, response.getProperty(i));        }
    }

    public void setBairro(java.lang.String bairro) {
        this.bairro = bairro;
    }

    public java.lang.String getBairro(java.lang.String bairro) {
        return this.bairro;
    }

    public void setCep(java.lang.String cep) {
        this.cep = cep;
    }

    public java.lang.String getCep(java.lang.String cep) {
        return this.cep;
    }

    public void setCidade(java.lang.String cidade) {
        this.cidade = cidade;
    }

    public java.lang.String getCidade(java.lang.String cidade) {
        return this.cidade;
    }

    public void setComplemento(java.lang.String complemento) {
        this.complemento = complemento;
    }

    public java.lang.String getComplemento(java.lang.String complemento) {
        return this.complemento;
    }

    public void setComplemento2(java.lang.String complemento2) {
        this.complemento2 = complemento2;
    }

    public java.lang.String getComplemento2(java.lang.String complemento2) {
        return this.complemento2;
    }

    public void setEnd(java.lang.String end) {
        this.end = end;
    }

    public java.lang.String getEnd(java.lang.String end) {
        return this.end;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getId(long id) {
        return this.id;
    }

    public void setUf(java.lang.String uf) {
        this.uf = uf;
    }

    public java.lang.String getUf(java.lang.String uf) {
        return this.uf;
    }

    public void setUnidadesPostagem(UnidadePostagem[] unidadesPostagem) {
        this.unidadesPostagem = unidadesPostagem;
    }

    public UnidadePostagem[] getUnidadesPostagem() {
        return this.unidadesPostagem;
    }

    public int getPropertyCount() {
        return 9;
    }

    public Object getProperty(int index) {
        switch (index) {
            case 0:
                return bairro;
            case 1:
                return cep;
            case 2:
                return cidade;
            case 3:
                return complemento;
            case 4:
                return complemento2;
            case 5:
                return end;
            case 6:
                return new Long(id);
            case 7:
                return uf;
        }
        return null;
    }

    public void setProperty(int index, Object obj) {
        switch (index) {
            case 0:
                bairro = (java.lang.String) obj;
                break;
            case 1:
                cep = (java.lang.String) obj;
                break;
            case 2:
                cidade = (java.lang.String) obj;
                break;
            case 3:
                complemento = (java.lang.String) obj;
                break;
            case 4:
                complemento2 = (java.lang.String) obj;
                break;
            case 5:
                end = (java.lang.String) obj;
                break;
            case 6:
                id = Long.parseLong(obj.toString());
                break;
            case 7:
                uf = (java.lang.String) obj;
                break;
        }
    }

    public void getPropertyInfo(int index, Hashtable table, PropertyInfo info) {
        switch (index) {
            case 0:
                info.name = "bairro";
                info.type = java.lang.String.class;
                break;
            case 1:
                info.name = "cep";
                info.type = java.lang.String.class;
                break;
            case 2:
                info.name = "cidade";
                info.type = java.lang.String.class;
                break;
            case 3:
                info.name = "complemento";
                info.type = java.lang.String.class;
                break;
            case 4:
                info.name = "complemento2";
                info.type = java.lang.String.class;
                break;
            case 5:
                info.name = "end";
                info.type = java.lang.String.class;
                break;
            case 6:
                info.name = "id";
                info.type = Long.class;
                break;
            case 7:
                info.name = "uf";
                info.type = java.lang.String.class;
                break;
            case 8:
                info.name = "unidadesPostagem";
        }
    }


    public static EnderecoCorreio of(SoapObject response) {
        return new EnderecoCorreio(response);
    }


    public final class UnidadePostagem extends SoapObject {
        private java.lang.String diretoriaRegional;

        private EnderecoCorreio endereco;

        private java.lang.String id;

        private java.lang.String nome;

        private java.lang.String status;

        private java.lang.String tipo;

        public UnidadePostagem() {
            super("", "");
        }
        public void setDiretoriaRegional(java.lang.String diretoriaRegional) {
            this.diretoriaRegional = diretoriaRegional;
        }

        public java.lang.String getDiretoriaRegional(java.lang.String diretoriaRegional) {
            return this.diretoriaRegional;
        }

        public void setEndereco(EnderecoCorreio endereco) {
            this.endereco = endereco;
        }

        public EnderecoCorreio getEndereco(EnderecoCorreio endereco) {
            return this.endereco;
        }

        public void setId(java.lang.String id) {
            this.id = id;
        }

        public java.lang.String getId(java.lang.String id) {
            return this.id;
        }

        public void setNome(java.lang.String nome) {
            this.nome = nome;
        }

        public java.lang.String getNome(java.lang.String nome) {
            return this.nome;
        }

        public void setStatus(java.lang.String status) {
            this.status = status;
        }

        public java.lang.String getStatus(java.lang.String status) {
            return this.status;
        }

        public void setTipo(java.lang.String tipo) {
            this.tipo = tipo;
        }

        public java.lang.String getTipo(java.lang.String tipo) {
            return this.tipo;
        }

        public int getPropertyCount() {
            return 6;
        }

        public Object getProperty(int index) {
            switch(index)  {
                case 0: return diretoriaRegional;
                case 1: return endereco;
                case 2: return id;
                case 3: return nome;
                case 4: return status;
                case 5: return tipo;
            }
            return null;
        }

        public void setProperty(int index, Object obj) {
            switch(index)  {
                case 0: diretoriaRegional = (java.lang.String) obj; break;
                case 1: endereco = (EnderecoCorreio) obj; break;
                case 2: id = (java.lang.String) obj; break;
                case 3: nome = (java.lang.String) obj; break;
                case 4: status = (java.lang.String) obj; break;
                case 5: tipo = (java.lang.String) obj; break;
            }
        }

        public void getPropertyInfo(int index, Hashtable table, PropertyInfo info) {
            switch(index)  {
                case 0:
                    info.name = "diretoriaRegional";
                    info.type = java.lang.String.class; break;
                case 1:
                    info.name = "endereco";
                    info.type = EnderecoCorreio.class; break;
                case 2:
                    info.name = "id";
                    info.type = java.lang.String.class; break;
                case 3:
                    info.name = "nome";
                    info.type = java.lang.String.class; break;
                case 4:
                    info.name = "status";
                    info.type = java.lang.String.class; break;
                case 5:
                    info.name = "tipo";
                    info.type = java.lang.String.class; break;
            }
        }

    }

}

