/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.spring.transaction;

import br.com.anteros.cloud.integration.filesharing.CloudFileManager;
import br.com.anteros.persistence.session.SQLSessionFactory;
import br.com.anteros.persistence.session.configuration.PackageScanEntity;
import br.com.anteros.spring.transaction.SpringSQLConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class SpringSQLSessionFactoryBean
implements FactoryBean<SQLSessionFactory>,
InitializingBean {
    protected SQLSessionFactory sessionFactory;
    protected Class<?>[] annotatedClasses;
    protected Properties properties;
    protected DataSource dataSource;
    protected String packageToScanEntity;
    protected boolean includeSecurityModel = false;
    protected CloudFileManager externalFileManager;
    protected boolean enableImageCompression;

    public void setAnnotatedClasses(Class<?>[] annotatedClasses) {
        this.annotatedClasses = annotatedClasses;
    }

    public void afterPropertiesSet() throws Exception {
        this.buildSessionFactory();
    }

    public SQLSessionFactory getObject() throws Exception {
        return this.sessionFactory;
    }

    public Class<?> getObjectType() {
        return this.sessionFactory != null ? this.sessionFactory.getClass() : SQLSessionFactory.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    protected void buildSessionFactory() throws Exception {
        SpringSQLConfiguration configuration = new SpringSQLConfiguration(this.getDataSource(), this.externalFileManager, this.enableImageCompression);
        ArrayList result = new ArrayList();
        if (this.getAnnotatedClasses() != null) {
            result.addAll(Arrays.asList(this.getAnnotatedClasses()));
        }
        for (Class clazz : result) {
            configuration.addAnnotatedClass(clazz);
        }
        configuration.getSessionFactoryConfiguration().setPackageToScanEntity(new PackageScanEntity(this.packageToScanEntity));
        configuration.getSessionFactoryConfiguration().setIncludeSecurityModel(this.includeSecurityModel);
        configuration.setProperties(this.getProperties());
        this.sessionFactory = configuration.buildSessionFactory();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Class<?>[] getAnnotatedClasses() {
        return this.annotatedClasses;
    }

    public SQLSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SQLSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public String getPackageToScanEntity() {
        return this.packageToScanEntity;
    }

    public void setPackageToScanEntity(String packageToScanEntity) {
        this.packageToScanEntity = packageToScanEntity;
    }

    public boolean isIncludeSecurityModel() {
        return this.includeSecurityModel;
    }

    public void setIncludeSecurityModel(boolean includeSecurityModel) {
        this.includeSecurityModel = includeSecurityModel;
    }

    public CloudFileManager getExternalFileManager() {
        return this.externalFileManager;
    }

    public void setExternalFileManager(CloudFileManager externalFileManager) {
        this.externalFileManager = externalFileManager;
    }

    public boolean isEnableImageCompression() {
        return this.enableImageCompression;
    }

    public void setEnableImageCompression(boolean enableImageCompression) {
        this.enableImageCompression = enableImageCompression;
    }
}

