/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.spring.config;

import br.com.anteros.dbcp.AnterosDBCPConfig;
import br.com.anteros.dbcp.AnterosDBCPDataSource;
import br.com.anteros.persistence.session.SQLSessionFactory;
import br.com.anteros.persistence.session.query.ShowSQLType;
import br.com.anteros.spring.config.AnterosDBCPDataSourceConfiguration;
import br.com.anteros.spring.config.PooledDataSourceConfiguration;
import br.com.anteros.spring.config.SQLSessionFactoryConfiguration;
import br.com.anteros.spring.config.SingleDataSourceConfiguration;
import br.com.anteros.spring.transaction.SpringSQLConfiguration;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import javax.sql.DataSource;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public abstract class AbstractSQLPersistenceConfiguration {
    public abstract PooledDataSourceConfiguration getPooledDataSourceConfiguration();

    public abstract SingleDataSourceConfiguration getSingleDataSourceConfiguration();

    public abstract SQLSessionFactoryConfiguration getSQLSessionFactoryConfiguration();

    @Bean
    public SQLSessionFactory sessionFactorySQL() throws Exception {
        SQLSessionFactoryConfiguration sqlSessionFactoryConfiguration = this.getSQLSessionFactoryConfiguration();
        if (sqlSessionFactoryConfiguration != null) {
            DataSource dataSource = this.dataSourceSQL();
            SpringSQLConfiguration configuration = new SpringSQLConfiguration(dataSource, sqlSessionFactoryConfiguration.getExternalFileManager(), sqlSessionFactoryConfiguration.isEnableImageCompression());
            for (Class<?> sourceClass : sqlSessionFactoryConfiguration.getEntitySourceClasses()) {
                configuration.addAnnotatedClass(sourceClass);
            }
            configuration.getSessionFactoryConfiguration().setPackageToScanEntity(sqlSessionFactoryConfiguration.getPackageScanEntity());
            configuration.getSessionFactoryConfiguration().setIncludeSecurityModel(sqlSessionFactoryConfiguration.isIncludeSecurityModel());
            configuration.addProperty("dialect", sqlSessionFactoryConfiguration.getDialect());
            configuration.addProperty("showsql", ShowSQLType.parse((ShowSQLType[])sqlSessionFactoryConfiguration.getShowSql()));
            configuration.addProperty("formatsql", String.valueOf(sqlSessionFactoryConfiguration.isFormatSql()));
            configuration.addProperty("defaultSchema", sqlSessionFactoryConfiguration.getJdbcSchema());
            configuration.addProperty("database-ddl-generation", sqlSessionFactoryConfiguration.getDatabaseDDLGeneration());
            configuration.addProperty("script-ddl-generation", sqlSessionFactoryConfiguration.getScriptDDLGeneration());
            configuration.addProperty("ddl-output-mode", sqlSessionFactoryConfiguration.getDDLOutputMode());
            configuration.addProperty("application-location", sqlSessionFactoryConfiguration.getApplicationLocation());
            configuration.addProperty("create-tables-file-name", sqlSessionFactoryConfiguration.getCreateTablesFileName());
            configuration.addProperty("drop-tables-file-name", sqlSessionFactoryConfiguration.getDropTablesFileName());
            configuration.addProperty("lock-timeout", sqlSessionFactoryConfiguration.getLockTimeout() + "");
            configuration.addProperty("use-bean-validation", sqlSessionFactoryConfiguration.getUseBeanValidation() + "");
            for (Object listener : sqlSessionFactoryConfiguration.getEntityListeners().keySet()) {
                Class<?> entity = sqlSessionFactoryConfiguration.getEntityListeners().get(listener);
                configuration.addEntityListener(entity, listener);
            }
            return configuration.buildSessionFactory();
        }
        return null;
    }

    @Bean
    public DataSource dataSourceSQL() throws Exception {
        if (this.getPooledDataSourceConfiguration() != null && this.getPooledDataSourceConfiguration() instanceof AnterosDBCPDataSourceConfiguration) {
            AnterosDBCPDataSourceConfiguration pooledDataSourceConfiguration = (AnterosDBCPDataSourceConfiguration)this.getPooledDataSourceConfiguration();
            AnterosDBCPConfig config = new AnterosDBCPConfig();
            config.setAutoCommit(false);
            config.setDriverClassName(pooledDataSourceConfiguration.getDriverClass());
            config.setJdbcUrl(pooledDataSourceConfiguration.getJdbcUrl());
            config.setPassword(pooledDataSourceConfiguration.getPassword());
            config.setUsername(pooledDataSourceConfiguration.getUser());
            config.setMaximumPoolSize(Integer.valueOf(pooledDataSourceConfiguration.getMaxPoolSize()).intValue());
            config.setConnectionTestQuery(pooledDataSourceConfiguration.getPreferredTestQuery());
            config.setReadOnly(false);
            config.setDataSourceProperties(pooledDataSourceConfiguration.getDataSourceProperties());
            AnterosDBCPDataSource dataSource = new AnterosDBCPDataSource(config);
            return dataSource;
        }
        if (this.getPooledDataSourceConfiguration() != null) {
            PooledDataSourceConfiguration pooledDataSourceConfiguration = this.getPooledDataSourceConfiguration();
            ComboPooledDataSource dataSource = new ComboPooledDataSource();
            dataSource.setDriverClass(pooledDataSourceConfiguration.getDriverClass());
            dataSource.setAcquireIncrement(Integer.valueOf(pooledDataSourceConfiguration.getAcquireIncrement()).intValue());
            dataSource.setJdbcUrl(pooledDataSourceConfiguration.getJdbcUrl());
            dataSource.setUser(pooledDataSourceConfiguration.getUser());
            dataSource.setPassword(pooledDataSourceConfiguration.getPassword());
            dataSource.setInitialPoolSize(Integer.valueOf(pooledDataSourceConfiguration.getInitialPoolSize()).intValue());
            dataSource.setMaxPoolSize(Integer.valueOf(pooledDataSourceConfiguration.getMaxPoolSize()).intValue());
            dataSource.setMinPoolSize(Integer.valueOf(pooledDataSourceConfiguration.getMinPoolSize()).intValue());
            dataSource.setMaxIdleTime(Integer.valueOf(pooledDataSourceConfiguration.getMaxIdleTime()).intValue());
            dataSource.setIdleConnectionTestPeriod(Integer.valueOf(pooledDataSourceConfiguration.getIdleConnectionTestPeriod()).intValue());
            dataSource.setAcquireRetryAttempts(pooledDataSourceConfiguration.getAcquireRetryAttempts());
            dataSource.setMaxConnectionAge(pooledDataSourceConfiguration.getMaxConnectionAge());
            dataSource.setAutomaticTestTable(pooledDataSourceConfiguration.getAutomaticTestTable());
            dataSource.setPreferredTestQuery(pooledDataSourceConfiguration.getPreferredTestQuery());
            dataSource.setTestConnectionOnCheckin(pooledDataSourceConfiguration.isTestConnectionOnCheckin());
            dataSource.setTestConnectionOnCheckout(pooledDataSourceConfiguration.isTestConnectionOnCheckout());
            return dataSource;
        }
        if (this.getSingleDataSourceConfiguration() != null) {
            SingleDataSourceConfiguration singleDataSourceConfiguration = this.getSingleDataSourceConfiguration();
            DriverManagerDataSource dataSource = new DriverManagerDataSource();
            dataSource.setDriverClassName(singleDataSourceConfiguration.getDriverClass());
            dataSource.setUsername(singleDataSourceConfiguration.getUser());
            dataSource.setPassword(singleDataSourceConfiguration.getPassword());
            dataSource.setUrl(singleDataSourceConfiguration.getJdbcUrl());
        }
        return null;
    }
}

