/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.spring.transaction;

import br.com.anteros.core.resource.messages.AnterosBundle;
import br.com.anteros.core.resource.messages.AnterosResourceBundle;
import br.com.anteros.persistence.session.AbstractSQLSessionFactory;
import br.com.anteros.persistence.session.SQLSession;
import br.com.anteros.persistence.session.SQLSessionFactory;
import br.com.anteros.persistence.session.query.SQLQuery;
import br.com.anteros.spring.resource.messages.AnterosSpringMessages;
import br.com.anteros.spring.transaction.SQLSessionHolder;
import br.com.anteros.spring.transaction.SpringSQLSessionSynchronization;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.NamedThreadLocal;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;
import org.springframework.transaction.jta.SpringJtaSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public abstract class SQLSessionFactoryUtils {
    public static final int SESSION_SYNCHRONIZATION_ORDER = 900;
    static final Log logger = LogFactory.getLog(SQLSessionFactoryUtils.class);
    private static AnterosBundle MESSAGES = AnterosResourceBundle.getBundle((String)"ANTEROS_SPRING", AnterosSpringMessages.class);
    private static final ThreadLocal<Map<SQLSessionFactory, Set<SQLSession>>> deferredCloseHolder = new NamedThreadLocal("Anteros Sessions registered for deferred close");

    public static DataSource getDataSource(SQLSessionFactory sessionFactory) {
        if (sessionFactory instanceof AbstractSQLSessionFactory) {
            return ((AbstractSQLSessionFactory)sessionFactory).getDataSource();
        }
        return null;
    }

    public static SQLExceptionTranslator newJdbcExceptionTranslator(SQLSessionFactory sessionFactory) {
        DataSource ds = SQLSessionFactoryUtils.getDataSource(sessionFactory);
        if (ds != null) {
            return new SQLErrorCodeSQLExceptionTranslator(ds);
        }
        return new SQLStateSQLExceptionTranslator();
    }

    public static TransactionManager getJtaTransactionManager(SQLSessionFactory sessionFactory, SQLSession session) throws Exception {
        SQLSessionFactory internalFactory;
        AbstractSQLSessionFactory sessionFactoryImpl = null;
        if (sessionFactory instanceof AbstractSQLSessionFactory) {
            sessionFactoryImpl = (AbstractSQLSessionFactory)sessionFactory;
        } else if (session != null && (internalFactory = session.getSQLSessionFactory()) instanceof AbstractSQLSessionFactory) {
            sessionFactoryImpl = (AbstractSQLSessionFactory)internalFactory;
        }
        return sessionFactoryImpl != null ? sessionFactoryImpl.getTransactionManager() : null;
    }

    public static SQLSession getSession(SQLSessionFactory sessionFactory, boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        try {
            return SQLSessionFactoryUtils.doGetSession(sessionFactory, allowCreate);
        }
        catch (Exception ex) {
            throw new DataAccessResourceFailureException("Could not open Anteros SQLSession", (Throwable)ex);
        }
    }

    public static SQLSession getSession(SQLSessionFactory sessionFactory) throws DataAccessResourceFailureException {
        try {
            return SQLSessionFactoryUtils.doGetSession(sessionFactory, true);
        }
        catch (Exception ex) {
            throw new DataAccessResourceFailureException("Could not open Anteros SQLSession", (Throwable)ex);
        }
    }

    public static SQLSession doGetSession(SQLSessionFactory sessionFactory, boolean allowCreate) throws Exception, IllegalStateException {
        return SQLSessionFactoryUtils.doGetSession(sessionFactory, null, allowCreate);
    }

    private static SQLSession doGetSession(SQLSessionFactory sessionFactory, SQLExceptionTranslator jdbcExceptionTranslator, boolean allowCreate) throws Exception, IllegalStateException {
        SQLSession session;
        Assert.notNull((Object)sessionFactory, (String)"No SQLSessionFactory specified");
        Object resource = TransactionSynchronizationManager.getResource((Object)sessionFactory);
        if (resource instanceof SQLSession) {
            return (SQLSession)resource;
        }
        SQLSessionHolder sessionHolder = (SQLSessionHolder)((Object)resource);
        if (sessionHolder != null && !sessionHolder.isEmpty()) {
            session = null;
            if (TransactionSynchronizationManager.isSynchronizationActive() && sessionHolder.doesNotHoldNonDefaultSession()) {
                session = sessionHolder.getValidatedSession();
                if (session != null && !sessionHolder.isSynchronizedWithTransaction()) {
                    logger.debug((Object)"Registering Spring transaction synchronization for existing Anteros SQLSession");
                    TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringSQLSessionSynchronization(sessionHolder, sessionFactory, jdbcExceptionTranslator, false));
                    sessionHolder.setSynchronizedWithTransaction(true);
                }
            } else {
                session = SQLSessionFactoryUtils.getJtaSynchronizedSession(sessionHolder, sessionFactory, jdbcExceptionTranslator);
            }
            if (session != null) {
                return session;
            }
        }
        logger.debug((Object)"Opening Anteros Session");
        session = sessionFactory.openSession();
        logger.debug((Object)"Opened session");
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            logger.debug((Object)"Registering Spring transaction synchronization for new Anteros SQLSession");
            SQLSessionHolder holderToUse = sessionHolder;
            if (holderToUse == null) {
                holderToUse = new SQLSessionHolder(session);
            } else {
                holderToUse.addSession(session);
            }
            if (TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                // empty if block
            }
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringSQLSessionSynchronization(holderToUse, sessionFactory, jdbcExceptionTranslator, true));
            holderToUse.setSynchronizedWithTransaction(true);
            if (holderToUse != sessionHolder) {
                TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)holderToUse));
            }
        } else {
            SQLSessionFactoryUtils.registerJtaSynchronization(session, sessionFactory, jdbcExceptionTranslator, sessionHolder);
        }
        if (!allowCreate && !SQLSessionFactoryUtils.isSessionTransactional(session, sessionFactory)) {
            SQLSessionFactoryUtils.closeSession(session);
            throw new IllegalStateException(MESSAGES.getMessage(SQLSessionFactoryUtils.class.getSimpleName() + ".NoSessionBoundToThread"));
        }
        logger.debug((Object)"Return session opened");
        return session;
    }

    private static SQLSession getJtaSynchronizedSession(SQLSessionHolder sessionHolder, SQLSessionFactory sessionFactory, SQLExceptionTranslator jdbcExceptionTranslator) throws Exception {
        TransactionManager jtaTm = SQLSessionFactoryUtils.getJtaTransactionManager(sessionFactory, sessionHolder.getAnySession());
        if (jtaTm != null) {
            try {
                int jtaStatus;
                Transaction jtaTx = jtaTm.getTransaction();
                if (jtaTx != null && ((jtaStatus = jtaTx.getStatus()) == 0 || jtaStatus == 1)) {
                    SQLSession session = sessionHolder.getValidatedSession(jtaTx);
                    if (session == null && !sessionHolder.isSynchronizedWithTransaction() && (session = sessionHolder.getValidatedSession()) != null) {
                        logger.debug((Object)"Registering JTA transaction synchronization for existing Anteros SQLSession");
                        sessionHolder.addSession(jtaTx, session);
                        jtaTx.registerSynchronization((Synchronization)new SpringJtaSynchronizationAdapter((TransactionSynchronization)new SpringSQLSessionSynchronization(sessionHolder, sessionFactory, jdbcExceptionTranslator, false), jtaTm));
                        sessionHolder.setSynchronizedWithTransaction(true);
                    }
                    return session;
                }
                return sessionHolder.getValidatedSession();
            }
            catch (Throwable ex) {
                throw new DataAccessResourceFailureException("Could not check JTA transaction", ex);
            }
        }
        return sessionHolder.getValidatedSession();
    }

    private static void registerJtaSynchronization(SQLSession session, SQLSessionFactory sessionFactory, SQLExceptionTranslator jdbcExceptionTranslator, SQLSessionHolder sessionHolder) throws Exception {
        TransactionManager jtaTm = SQLSessionFactoryUtils.getJtaTransactionManager(sessionFactory, session);
        if (jtaTm != null) {
            try {
                int jtaStatus;
                Transaction jtaTx = jtaTm.getTransaction();
                if (jtaTx != null && ((jtaStatus = jtaTx.getStatus()) == 0 || jtaStatus == 1)) {
                    logger.debug((Object)"Registering JTA transaction synchronization for new Anteros SQLSession");
                    SQLSessionHolder holderToUse = sessionHolder;
                    if (holderToUse == null) {
                        holderToUse = new SQLSessionHolder(jtaTx, session);
                    } else {
                        holderToUse.addSession(jtaTx, session);
                    }
                    jtaTx.registerSynchronization((Synchronization)new SpringJtaSynchronizationAdapter((TransactionSynchronization)new SpringSQLSessionSynchronization(holderToUse, sessionFactory, jdbcExceptionTranslator, true), jtaTm));
                    holderToUse.setSynchronizedWithTransaction(true);
                    if (holderToUse != sessionHolder) {
                        TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)holderToUse));
                    }
                }
            }
            catch (Throwable ex) {
                throw new DataAccessResourceFailureException("Could not register synchronization with JTA TransactionManager", ex);
            }
        }
    }

    public static SQLSession getNewSession(SQLSessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"No SQLSessionFactory specified");
        try {
            SQLSessionHolder sessionHolder = (SQLSessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
            if (sessionHolder != null && !sessionHolder.isEmpty()) {
                return sessionFactory.openSession(sessionHolder.getAnySession().getConnection());
            }
            return sessionFactory.openSession();
        }
        catch (Exception ex) {
            throw new DataAccessResourceFailureException("Could not open Anteros SQLSession", (Throwable)ex);
        }
    }

    public static String toString(SQLSession session) {
        return session.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(session));
    }

    public static boolean hasTransactionalSession(SQLSessionFactory sessionFactory) {
        if (sessionFactory == null) {
            return false;
        }
        SQLSessionHolder sessionHolder = (SQLSessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        return sessionHolder != null && !sessionHolder.isEmpty();
    }

    public static boolean isSessionTransactional(SQLSession session, SQLSessionFactory sessionFactory) {
        if (sessionFactory == null) {
            return false;
        }
        SQLSessionHolder sessionHolder = (SQLSessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        return sessionHolder != null && sessionHolder.containsSession(session);
    }

    public static void applyTransactionTimeout(SQLQuery query, SQLSessionFactory sessionFactory) {
        SQLSessionHolder sessionHolder;
        Assert.notNull((Object)query, (String)"No SQLQuery object specified");
        if (sessionFactory == null || (sessionHolder = (SQLSessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory))) == null || sessionHolder.hasTimeout()) {
            // empty if block
        }
    }

    public static boolean isDeferredCloseActive(SQLSessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"No SQLSessionFactory specified");
        Map<SQLSessionFactory, Set<SQLSession>> holderMap = deferredCloseHolder.get();
        return holderMap != null && holderMap.containsKey(sessionFactory);
    }

    public static void initDeferredClose(SQLSessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"No SQLSessionFactory specified");
        logger.debug((Object)"Initializing deferred close of Anteros Sessions");
        Map<SQLSessionFactory, Set<SQLSession>> holderMap = deferredCloseHolder.get();
        if (holderMap == null) {
            holderMap = new HashMap<SQLSessionFactory, Set<SQLSession>>();
            deferredCloseHolder.set(holderMap);
        }
        holderMap.put(sessionFactory, new LinkedHashSet(4));
    }

    public static void processDeferredClose(SQLSessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"No SQLSessionFactory specified");
        Map<SQLSessionFactory, Set<SQLSession>> holderMap = deferredCloseHolder.get();
        if (holderMap == null || !holderMap.containsKey(sessionFactory)) {
            throw new IllegalStateException("Deferred close not active for SQLSessionFactory [" + sessionFactory + "]");
        }
        logger.debug((Object)"Processing deferred close of Anteros Sessions");
        Set<SQLSession> sessions = holderMap.remove(sessionFactory);
        for (SQLSession session : sessions) {
            SQLSessionFactoryUtils.closeSession(session);
        }
        if (holderMap.isEmpty()) {
            deferredCloseHolder.remove();
        }
    }

    public static void releaseSession(SQLSession session, SQLSessionFactory sessionFactory) {
        if (session == null) {
            return;
        }
        if (!SQLSessionFactoryUtils.isSessionTransactional(session, sessionFactory)) {
            SQLSessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, sessionFactory);
        }
    }

    static void closeSessionOrRegisterDeferredClose(SQLSession session, SQLSessionFactory sessionFactory) {
        Map<SQLSessionFactory, Set<SQLSession>> holderMap = deferredCloseHolder.get();
        if (holderMap != null && sessionFactory != null && holderMap.containsKey(sessionFactory)) {
            logger.debug((Object)"Registering Anteros SQLSession for deferred close");
            Set<SQLSession> sessions = holderMap.get(sessionFactory);
            sessions.add(session);
        } else {
            SQLSessionFactoryUtils.closeSession(session);
        }
    }

    public static void closeSession(SQLSession session) {
        if (session != null) {
            logger.debug((Object)"Closing Anteros SQLSession");
            try {
                session.close();
            }
            catch (Throwable ex) {
                logger.debug((Object)"Unexpected exception on closing Anteros SQLSession", ex);
            }
        }
    }
}

