/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.spring.config;

import br.com.anteros.persistence.session.configuration.PackageScanEntity;
import br.com.anteros.persistence.session.query.ShowSQLType;
import java.util.ArrayList;
import java.util.List;

public class SQLSessionFactoryConfiguration {
    private List<Class<?>> entitySourceClasses = new ArrayList();
    private PackageScanEntity packageScanEntity = null;
    private Boolean includeSecurityModel = true;
    private String dialect;
    private ShowSQLType[] showSql = new ShowSQLType[]{ShowSQLType.NONE};
    private Boolean formatSql = true;
    private String jdbcSchema = "";
    private String databaseDDLGeneration = "none";
    private String scriptDDLGeneration = "none";
    private String ddlOutputMode = "none";
    private String applicationLocation = "";
    private String createTablesFileName = "";
    private String dropTablesFileName = "";
    private Long lockTimeout = 0L;
    private Boolean useBeanValidation = true;

    private SQLSessionFactoryConfiguration() {
    }

    public static SQLSessionFactoryConfiguration create() {
        return new SQLSessionFactoryConfiguration();
    }

    public List<Class<?>> getEntitySourceClasses() {
        return this.entitySourceClasses;
    }

    public SQLSessionFactoryConfiguration addEntitySourceClass(Class<?> entitySourceClass) {
        this.entitySourceClasses.add(entitySourceClass);
        return this;
    }

    public PackageScanEntity getPackageScanEntity() {
        return this.packageScanEntity;
    }

    public SQLSessionFactoryConfiguration packageScanEntity(PackageScanEntity packageScanEntity) {
        this.packageScanEntity = packageScanEntity;
        return this;
    }

    public boolean isIncludeSecurityModel() {
        return this.includeSecurityModel;
    }

    public SQLSessionFactoryConfiguration includeSecurityModel(boolean includeSecurityModel) {
        this.includeSecurityModel = includeSecurityModel;
        return this;
    }

    public String getDialect() {
        return this.dialect;
    }

    public SQLSessionFactoryConfiguration dialect(String dialect) {
        this.dialect = dialect;
        return this;
    }

    public ShowSQLType[] getShowSql() {
        return this.showSql;
    }

    public SQLSessionFactoryConfiguration showSql(ShowSQLType ... showSql) {
        this.showSql = showSql;
        return this;
    }

    public boolean isFormatSql() {
        return this.formatSql;
    }

    public SQLSessionFactoryConfiguration formatSql(boolean formatSql) {
        this.formatSql = formatSql;
        return this;
    }

    public String getJdbcSchema() {
        return this.jdbcSchema;
    }

    public SQLSessionFactoryConfiguration jdbcSchema(String jdbcSchema) {
        this.jdbcSchema = jdbcSchema;
        return this;
    }

    public String getDatabaseDDLGeneration() {
        return this.databaseDDLGeneration;
    }

    public SQLSessionFactoryConfiguration databaseDDLGeneration(String databaseDDLGeneration) {
        this.databaseDDLGeneration = databaseDDLGeneration;
        return this;
    }

    public String getScriptDDLGeneration() {
        return this.scriptDDLGeneration;
    }

    public SQLSessionFactoryConfiguration scriptDDLGeneration(String scriptDDLGeneration) {
        this.scriptDDLGeneration = scriptDDLGeneration;
        return this;
    }

    public String getDDLOutputMode() {
        return this.ddlOutputMode;
    }

    public SQLSessionFactoryConfiguration ddlOutputMode(String ddlOutputMode) {
        this.ddlOutputMode = ddlOutputMode;
        return this;
    }

    public String getApplicationLocation() {
        return this.applicationLocation;
    }

    public SQLSessionFactoryConfiguration applicationLocation(String applicationLocation) {
        this.applicationLocation = applicationLocation;
        return this;
    }

    public String getCreateTablesFileName() {
        return this.createTablesFileName;
    }

    public SQLSessionFactoryConfiguration createTablesFileName(String createTablesFileName) {
        this.createTablesFileName = createTablesFileName;
        return this;
    }

    public String getDropTablesFileName() {
        return this.dropTablesFileName;
    }

    public SQLSessionFactoryConfiguration dropTablesFileName(String dropTablesFileName) {
        this.dropTablesFileName = dropTablesFileName;
        return this;
    }

    public Long getLockTimeout() {
        return this.lockTimeout;
    }

    public SQLSessionFactoryConfiguration lockTimeout(Long lockTimeout) {
        this.lockTimeout = lockTimeout;
        return this;
    }

    public Boolean getUseBeanValidation() {
        return this.useBeanValidation;
    }

    public SQLSessionFactoryConfiguration useBeanValidation(Boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
        return this;
    }
}

