/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.spring.transaction;

import br.com.anteros.persistence.session.SQLSession;
import br.com.anteros.persistence.session.SQLSessionFactory;
import br.com.anteros.persistence.transaction.Transaction;
import br.com.anteros.spring.transaction.SQLSessionFactoryUtils;
import br.com.anteros.spring.transaction.SQLSessionHolder;
import java.sql.Connection;
import javax.sql.DataSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.JdbcTransactionObjectSupport;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class AnterosTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager,
BeanFactoryAware,
InitializingBean {
    private SQLSessionFactory sessionFactory;
    private DataSource dataSource;
    private boolean autodetectDataSource = true;
    private boolean prepareConnection = true;
    private boolean managedSession = false;
    private boolean earlyFlushBeforeCommit = false;
    private SQLExceptionTranslator jdbcExceptionTranslator;
    private SQLExceptionTranslator defaultJdbcExceptionTranslator;
    private BeanFactory beanFactory;

    public AnterosTransactionManager() {
    }

    public AnterosTransactionManager(SQLSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.afterPropertiesSet();
    }

    public void setSessionFactory(SQLSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SQLSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource instanceof TransactionAwareDataSourceProxy ? ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource() : dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setAutodetectDataSource(boolean autodetectDataSource) {
        this.autodetectDataSource = autodetectDataSource;
    }

    public void setPrepareConnection(boolean prepareConnection) {
        this.prepareConnection = prepareConnection;
    }

    public void setManagedSession(boolean managedSession) {
        this.managedSession = managedSession;
    }

    public void setEarlyFlushBeforeCommit(boolean earlyFlushBeforeCommit) {
        this.earlyFlushBeforeCommit = earlyFlushBeforeCommit;
    }

    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
    }

    public SQLExceptionTranslator getJdbcExceptionTranslator() {
        return this.jdbcExceptionTranslator;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() {
        DataSource sfds;
        if (this.getSessionFactory() == null) {
            throw new IllegalArgumentException("Property 'sessionFactory' is required");
        }
        if (this.autodetectDataSource && this.getDataSource() == null && (sfds = SQLSessionFactoryUtils.getDataSource(this.getSessionFactory())) != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Using DataSource [" + sfds + "] of Anteros SQLSessionFactory for AnterosTransactionManager"));
            }
            this.setDataSource(sfds);
        }
    }

    public Object getResourceFactory() {
        return this.getSessionFactory();
    }

    protected Object doGetTransaction() {
        AnterosTransactionObject txObject = new AnterosTransactionObject();
        txObject.setSavepointAllowed(this.isNestedTransactionAllowed());
        SQLSessionHolder sessionHolder = (SQLSessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getSessionFactory()));
        if (sessionHolder != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found thread-bound SQLSession [" + SQLSessionFactoryUtils.toString(sessionHolder.getSession()) + "] for Anteros transaction"));
            }
            txObject.setSessionHolder(sessionHolder);
        } else if (this.managedSession) {
            try {
                SQLSession session = this.getSessionFactory().getCurrentSession();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Found Anteros-managed SQLSession [" + SQLSessionFactoryUtils.toString(session) + "] for Spring-managed transaction"));
                }
                txObject.setExistingSession(session);
            }
            catch (Exception ex) {
                throw new DataAccessResourceFailureException("Could not obtain Anteros-managed SQLSession for Spring-managed transaction", (Throwable)ex);
            }
        }
        if (this.getDataSource() != null) {
            ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)this.getDataSource());
            txObject.setConnectionHolder(conHolder);
        }
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        AnterosTransactionObject txObject = (AnterosTransactionObject)((Object)transaction);
        try {
            return txObject.hasSpringManagedTransaction() || this.managedSession && txObject.hasManagedTransaction();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        AnterosTransactionObject txObject = (AnterosTransactionObject)((Object)transaction);
        if (txObject.hasConnectionHolder() && !txObject.getConnectionHolder().isSynchronizedWithTransaction()) {
            throw new IllegalTransactionStateException("Pre-bound JDBC Connection found! AnterosTransactionManager does not support running within DataSourceTransactionManager if told to manage the DataSource itself. It is recommended to use a single AnterosTransactionManager for all transactions on a single DataSource, no matter whether Anteros or JDBC access.");
        }
        SQLSession session = null;
        try {
            if (txObject.getSessionHolder() == null || txObject.getSessionHolder().isSynchronizedWithTransaction()) {
                SQLSession newSession = this.getSessionFactory().openSession();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Opened new SQLSession [" + SQLSessionFactoryUtils.toString(newSession) + "] for Anteros transaction"));
                }
                txObject.setSession(newSession);
            }
            session = txObject.getSessionHolder().getSession();
            if (this.prepareConnection) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Preparing JDBC Connection of Anteros SQLSession [" + SQLSessionFactoryUtils.toString(session) + "]"));
                }
                Connection con = session.getConnection();
                Integer previousIsolationLevel = DataSourceUtils.prepareConnectionForTransaction((Connection)con, (TransactionDefinition)definition);
                txObject.setPreviousIsolationLevel(previousIsolationLevel);
            } else {
                if (definition.getIsolationLevel() != -1) {
                    throw new InvalidIsolationLevelException("AnterosTransactionManager is not allowed to support custom isolation levels: make sure that its 'prepareConnection' flag is on (the default) and that the Anteros connection release mode is set to 'on_close' (SpringTransactionFactory's default). Make sure that your LocalSessionFactoryBean actually uses SpringTransactionFactory: Your Anteros properties should *not* include a 'anteros.transaction.factory_class' property!");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Not preparing JDBC Connection of Anteros Session [" + SQLSessionFactoryUtils.toString(session) + "]"));
                }
            }
            Transaction hibTx = session.getTransaction();
            hibTx.begin();
            int timeout = this.determineTimeout(definition);
            txObject.getSessionHolder().setTransaction(hibTx);
            if (this.getDataSource() != null) {
                Connection con = session.getConnection();
                ConnectionHolder conHolder = new ConnectionHolder(con);
                if (timeout != -1) {
                    conHolder.setTimeoutInSeconds(timeout);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Exposing Anteros transaction as JDBC transaction [" + con + "]"));
                }
                TransactionSynchronizationManager.bindResource((Object)this.getDataSource(), (Object)conHolder);
                txObject.setConnectionHolder(conHolder);
            }
            if (txObject.isNewSessionHolder()) {
                TransactionSynchronizationManager.bindResource((Object)this.getSessionFactory(), (Object)((Object)txObject.getSessionHolder()));
            }
            txObject.getSessionHolder().setSynchronizedWithTransaction(true);
        }
        catch (Throwable ex) {
            block21: {
                if (txObject.isNewSession()) {
                    try {
                        try {
                            if (session.getTransaction().isActive()) {
                                session.getTransaction().rollback();
                            }
                        }
                        catch (Throwable ex2) {
                            this.logger.debug((Object)"Could not rollback Session after failed transaction begin", ex);
                            SQLSessionFactoryUtils.closeSession(session);
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        SQLSessionFactoryUtils.closeSession(session);
                        throw throwable;
                    }
                    SQLSessionFactoryUtils.closeSession(session);
                }
            }
            throw new CannotCreateTransactionException("Could not open Anteros SQLSession for transaction", ex);
        }
    }

    protected Object doSuspend(Object transaction) {
        AnterosTransactionObject txObject = (AnterosTransactionObject)((Object)transaction);
        txObject.setSessionHolder(null);
        SQLSessionHolder sessionHolder = (SQLSessionHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory()));
        txObject.setConnectionHolder(null);
        ConnectionHolder connectionHolder = null;
        if (this.getDataSource() != null) {
            connectionHolder = (ConnectionHolder)TransactionSynchronizationManager.unbindResource((Object)this.getDataSource());
        }
        return new SuspendedResourcesHolder(sessionHolder, connectionHolder);
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        SuspendedResourcesHolder resourcesHolder = (SuspendedResourcesHolder)suspendedResources;
        if (TransactionSynchronizationManager.hasResource((Object)this.getSessionFactory())) {
            TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
        }
        TransactionSynchronizationManager.bindResource((Object)this.getSessionFactory(), (Object)((Object)resourcesHolder.getSessionHolder()));
        if (this.getDataSource() != null) {
            TransactionSynchronizationManager.bindResource((Object)this.getDataSource(), (Object)resourcesHolder.getConnectionHolder());
        }
    }

    protected void prepareForCommit(DefaultTransactionStatus status) {
        if (this.earlyFlushBeforeCommit) {
            status.isNewTransaction();
        }
    }

    protected void doCommit(DefaultTransactionStatus status) {
        AnterosTransactionObject txObject = (AnterosTransactionObject)((Object)status.getTransaction());
        if (status.isDebug()) {
            this.logger.debug((Object)("Committing Anteros transaction on SQLSession [" + SQLSessionFactoryUtils.toString(txObject.getSessionHolder().getSession()) + "]"));
        }
        try {
            txObject.getSessionHolder().getTransaction().commit();
        }
        catch (Exception ex) {
            throw new TransactionSystemException("Could not commit Anteros transaction", (Throwable)ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        AnterosTransactionObject txObject = (AnterosTransactionObject)((Object)status.getTransaction());
        if (status.isDebug()) {
            this.logger.debug((Object)("Rolling back Anteros transaction on SQLSession [" + SQLSessionFactoryUtils.toString(txObject.getSessionHolder().getSession()) + "]"));
        }
        try {
            try {
                txObject.getSessionHolder().getTransaction().rollback();
            }
            catch (Exception ex) {
                throw new TransactionSystemException("Could not roll back Anteros transaction", (Throwable)ex);
            }
        }
        finally {
            if (!txObject.isNewSession() && !this.managedSession) {
                try {
                    txObject.getSessionHolder().getSession().clear();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        AnterosTransactionObject txObject = (AnterosTransactionObject)((Object)status.getTransaction());
        if (status.isDebug()) {
            this.logger.debug((Object)("Setting Anteros transaction on SQLSession [" + SQLSessionFactoryUtils.toString(txObject.getSessionHolder().getSession()) + "] rollback-only"));
        }
        txObject.setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        boolean closed;
        AnterosTransactionObject txObject = (AnterosTransactionObject)((Object)transaction);
        if (txObject.isNewSessionHolder()) {
            TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
        }
        if (this.getDataSource() != null) {
            TransactionSynchronizationManager.unbindResource((Object)this.getDataSource());
        }
        SQLSession session = txObject.getSessionHolder().getSession();
        try {
            closed = session.isClosed();
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        if (this.prepareConnection && !closed) {
            try {
                Connection con = session.getConnection();
                DataSourceUtils.resetConnectionAfterTransaction((Connection)con, (Integer)txObject.getPreviousIsolationLevel());
            }
            catch (Exception ex) {
                this.logger.debug((Object)"Could not access JDBC Connection of Anteros SQLSession", (Throwable)ex);
            }
        }
        if (txObject.isNewSession()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Closing Anteros SQLSession [" + SQLSessionFactoryUtils.toString(session) + "] after transaction"));
            }
            SQLSessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, this.getSessionFactory());
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Not closing pre-bound Anteros SQLSession [" + SQLSessionFactoryUtils.toString(session) + "] after transaction"));
        }
        txObject.getSessionHolder().clear();
    }

    protected synchronized SQLExceptionTranslator getDefaultJdbcExceptionTranslator() {
        if (this.defaultJdbcExceptionTranslator == null) {
            this.defaultJdbcExceptionTranslator = this.getDataSource() != null ? new SQLErrorCodeSQLExceptionTranslator(this.getDataSource()) : SQLSessionFactoryUtils.newJdbcExceptionTranslator(this.getSessionFactory());
        }
        return this.defaultJdbcExceptionTranslator;
    }

    private class AnterosTransactionObject
    extends JdbcTransactionObjectSupport {
        private SQLSessionHolder sessionHolder;
        private boolean newSessionHolder;
        private boolean newSession;

        private AnterosTransactionObject() {
        }

        public void setSession(SQLSession session) {
            this.sessionHolder = new SQLSessionHolder(session);
            this.newSessionHolder = true;
            this.newSession = true;
        }

        public void setExistingSession(SQLSession session) {
            this.sessionHolder = new SQLSessionHolder(session);
            this.newSessionHolder = true;
            this.newSession = false;
        }

        public void setSessionHolder(SQLSessionHolder sessionHolder) {
            this.sessionHolder = sessionHolder;
            this.newSessionHolder = false;
            this.newSession = false;
        }

        public SQLSessionHolder getSessionHolder() {
            return this.sessionHolder;
        }

        public boolean isNewSessionHolder() {
            return this.newSessionHolder;
        }

        public boolean isNewSession() {
            return this.newSession;
        }

        public boolean hasSpringManagedTransaction() {
            return this.sessionHolder != null && this.sessionHolder.getTransaction() != null;
        }

        public boolean hasManagedTransaction() throws Exception {
            return this.sessionHolder != null && this.sessionHolder.getSession().getTransaction().isActive();
        }

        public void setRollbackOnly() {
            this.sessionHolder.setRollbackOnly();
            if (this.hasConnectionHolder()) {
                this.getConnectionHolder().setRollbackOnly();
            }
        }

        public boolean isRollbackOnly() {
            return this.sessionHolder.isRollbackOnly() || this.hasConnectionHolder() && this.getConnectionHolder().isRollbackOnly();
        }

        public void flush() {
            try {
                this.sessionHolder.getSession().flush();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static class SuspendedResourcesHolder {
        private final SQLSessionHolder sessionHolder;
        private final ConnectionHolder connectionHolder;

        private SuspendedResourcesHolder(SQLSessionHolder sessionHolder, ConnectionHolder conHolder) {
            this.sessionHolder = sessionHolder;
            this.connectionHolder = conHolder;
        }

        private SQLSessionHolder getSessionHolder() {
            return this.sessionHolder;
        }

        private ConnectionHolder getConnectionHolder() {
            return this.connectionHolder;
        }
    }
}

