/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.spring.config;

import br.com.anteros.persistence.session.SQLSessionFactory;
import br.com.anteros.persistence.session.query.ShowSQLType;
import br.com.anteros.spring.config.PooledDataSourceConfiguration;
import br.com.anteros.spring.config.SQLSessionFactoryConfiguration;
import br.com.anteros.spring.config.SingleDataSourceConfiguration;
import br.com.anteros.spring.transaction.SpringSQLConfiguration;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import javax.sql.DataSource;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public abstract class AnterosSpringPersistenceConfiguration {
    public abstract PooledDataSourceConfiguration getPooledDataSourceConfiguration();

    public abstract SingleDataSourceConfiguration getSingleDataSourceConfiguration();

    public abstract SQLSessionFactoryConfiguration getSQLSessionFactoryConfiguration();

    @Bean
    public SQLSessionFactory sessionFactory() throws Exception {
        SQLSessionFactoryConfiguration sqlSessionFactoryConfiguration = this.getSQLSessionFactoryConfiguration();
        if (sqlSessionFactoryConfiguration != null) {
            DataSource dataSource = this.dataSource();
            SpringSQLConfiguration configuration = new SpringSQLConfiguration(dataSource);
            for (Class<?> sourceClass : sqlSessionFactoryConfiguration.getEntitySourceClasses()) {
                configuration.addAnnotatedClass(sourceClass);
            }
            configuration.getSessionFactoryConfiguration().setPackageToScanEntity(sqlSessionFactoryConfiguration.getPackageScanEntity());
            configuration.getSessionFactoryConfiguration().setIncludeSecurityModel(true);
            configuration.addProperty("dialect", sqlSessionFactoryConfiguration.getDialect());
            configuration.addProperty("showsql", ShowSQLType.parse((ShowSQLType[])sqlSessionFactoryConfiguration.getShowSql()));
            configuration.addProperty("formatsql", String.valueOf(sqlSessionFactoryConfiguration.isFormatSql()));
            configuration.addProperty("defaultSchema", sqlSessionFactoryConfiguration.getJdbcSchema());
            configuration.addProperty("database-ddl-generation", sqlSessionFactoryConfiguration.getDatabaseDdlGeneration());
            configuration.addProperty("ddl-output-mode", sqlSessionFactoryConfiguration.getDdlOutputMode());
            configuration.addProperty("application-location", sqlSessionFactoryConfiguration.getApplicationLocation());
            configuration.addProperty("create-tables-file-name", sqlSessionFactoryConfiguration.getCreateTablesFileName());
            configuration.addProperty("drop-tables-file-name", sqlSessionFactoryConfiguration.getDropTablesFileName());
            return configuration.buildSessionFactory();
        }
        return null;
    }

    @Bean
    public DataSource dataSource() throws Exception {
        if (this.getPooledDataSourceConfiguration() != null) {
            PooledDataSourceConfiguration pooledDataSourceConfiguration = this.getPooledDataSourceConfiguration();
            ComboPooledDataSource dataSource = new ComboPooledDataSource();
            dataSource.setDriverClass(pooledDataSourceConfiguration.getDriverClass());
            dataSource.setAcquireIncrement(Integer.valueOf(pooledDataSourceConfiguration.getAcquireIncrement()).intValue());
            dataSource.setJdbcUrl(pooledDataSourceConfiguration.getJdbcUrl());
            dataSource.setUser(pooledDataSourceConfiguration.getUser());
            dataSource.setPassword(pooledDataSourceConfiguration.getPassword());
            dataSource.setInitialPoolSize(Integer.valueOf(pooledDataSourceConfiguration.getInitialPoolSize()).intValue());
            dataSource.setMaxPoolSize(Integer.valueOf(pooledDataSourceConfiguration.getMaxPoolSize()).intValue());
            dataSource.setMinPoolSize(Integer.valueOf(pooledDataSourceConfiguration.getMinPoolSize()).intValue());
            dataSource.setMaxIdleTime(Integer.valueOf(pooledDataSourceConfiguration.getMaxIdleTime()).intValue());
            dataSource.setIdleConnectionTestPeriod(Integer.valueOf(pooledDataSourceConfiguration.getIdleConnectionTestPeriod()).intValue());
            return dataSource;
        }
        if (this.getSingleDataSourceConfiguration() != null) {
            SingleDataSourceConfiguration singleDataSourceConfiguration = this.getSingleDataSourceConfiguration();
            DriverManagerDataSource dataSource = new DriverManagerDataSource();
            dataSource.setDriverClassName(singleDataSourceConfiguration.getDriverClass());
            dataSource.setUsername(singleDataSourceConfiguration.getUser());
            dataSource.setPassword(singleDataSourceConfiguration.getPassword());
            dataSource.setUrl(singleDataSourceConfiguration.getJdbcUrl());
        }
        return null;
    }
}

