/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.store.sql.repository;

import br.com.anteros.persistence.parameter.NamedParameter;
import br.com.anteros.persistence.session.SQLSessionFactory;
import br.com.anteros.persistence.session.repository.impl.GenericSQLRepository;
import br.com.anteros.security.model.System;
import br.com.anteros.security.store.exception.AnterosSecurityStoreException;
import br.com.anteros.security.store.sql.repository.SystemRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Repository;

@Repository(value="systemRepositorySql")
@Scope(value="prototype")
public class SystemRepositoryImpl
extends GenericSQLRepository<System, Long>
implements SystemRepository {
    @Autowired
    public SystemRepositoryImpl(@Qualifier(value="securitySessionFactory") SQLSessionFactory sessionFactory) throws Exception {
        super(sessionFactory);
    }

    @Override
    public System getSystemByName(String systemName) {
        System system = (System)this.findOneBySql("select sis.* from SEGURANCASISTEMA sis where sis.nome_sistema = :pnome_sistema", new NamedParameter("pnome_sistema", (Object)systemName), null);
        return system;
    }

    @Override
    public System addSystem(String systemName, String description) {
        try {
            System newSystem = System.of(systemName, description);
            this.getSession().getTransaction().begin();
            this.getSession().save((Object)newSystem);
            this.getSession().getTransaction().commit();
            return newSystem;
        }
        catch (Exception e) {
            try {
                this.getSession().getTransaction().rollback();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            throw new AnterosSecurityStoreException((Throwable)e);
        }
    }
}

