/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.store.sql.service;

import br.com.anteros.core.utils.SerializationUtils;
import br.com.anteros.security.model.AccessToken;
import br.com.anteros.security.model.Approval;
import br.com.anteros.security.model.RefreshToken;
import br.com.anteros.security.model.Resource;
import br.com.anteros.security.store.SecurityDataStore;
import br.com.anteros.security.store.domain.IAction;
import br.com.anteros.security.store.domain.IResource;
import br.com.anteros.security.store.domain.ISystem;
import br.com.anteros.security.store.domain.IUser;
import br.com.anteros.security.store.exception.AnterosSecurityStoreException;
import br.com.anteros.security.store.sql.repository.AccessTokenRepository;
import br.com.anteros.security.store.sql.repository.ActionRepository;
import br.com.anteros.security.store.sql.repository.ApprovalRepository;
import br.com.anteros.security.store.sql.repository.RefreshTokenRepository;
import br.com.anteros.security.store.sql.repository.ResourceRepository;
import br.com.anteros.security.store.sql.repository.SecurityRepository;
import br.com.anteros.security.store.sql.repository.SystemRepository;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.approval.Approval;
import org.springframework.security.oauth2.provider.token.AuthenticationKeyGenerator;
import org.springframework.stereotype.Service;

@Service(value="securityDataStore")
@Scope(value="prototype")
public class SQLSecurityDataStore
implements SecurityDataStore {
    @Autowired
    protected SecurityRepository securityRepositorySql;
    @Autowired
    protected SystemRepository systemRepositorySql;
    @Autowired
    protected ResourceRepository resourceRepositorySql;
    @Autowired
    protected ActionRepository actionRepositorySql;
    @Autowired
    protected ApprovalRepository approvalRepositorySql;
    @Autowired
    protected AccessTokenRepository accessTokenRepositorySql;
    @Autowired
    protected RefreshTokenRepository refreshTokenRepositorySql;
    private boolean handleRevocationsAsExpiry = false;

    public void setHandleRevocationsAsExpiry(boolean handleRevocationsAsExpiry) {
        this.handleRevocationsAsExpiry = handleRevocationsAsExpiry;
    }

    public IResource getResourceByName(String systemName, String resourceName) {
        return this.resourceRepositorySql.getResourceByName(systemName, resourceName);
    }

    public ISystem getSystemByName(String systemName) {
        return this.systemRepositorySql.getSystemByName(systemName);
    }

    public ISystem addSystem(String systemName, String description) {
        return this.systemRepositorySql.addSystem(systemName, description);
    }

    public IResource addResource(ISystem system, String resourceName, String description) throws Exception {
        return this.resourceRepositorySql.addResource(system, resourceName, description);
    }

    public IAction addAction(ISystem system, IResource resource, String actionName, String category, String description, String version) throws Exception {
        return this.actionRepositorySql.addAction(system, resource, actionName, category, description, version);
    }

    public IAction saveAction(IAction action) throws Exception {
        try {
            this.actionRepositorySql.getSession().getTransaction().begin();
            this.actionRepositorySql.getSession().save((Object)action);
            this.actionRepositorySql.getSession().getTransaction().commit();
        }
        catch (Exception e) {
            this.actionRepositorySql.getSession().getTransaction().rollback();
            throw new AnterosSecurityStoreException((Throwable)e);
        }
        return action;
    }

    public IResource refreshResource(IResource resource) throws Exception {
        this.resourceRepositorySql.refresh((Resource)resource);
        return resource;
    }

    public void removeActionByAllUsers(IAction act) throws Exception {
        this.actionRepositorySql.removeActionByAllUsers(act);
    }

    public IUser getUserByUserName(String username) {
        return this.securityRepositorySql.getUserByUserName(username);
    }

    public void addApprovals(Collection<org.springframework.security.oauth2.provider.approval.Approval> approvals) {
        Collection<Approval> mongoApprovals = this.transformToApproval(approvals);
        this.approvalRepositorySql.updateOrCreate(mongoApprovals);
    }

    private Collection<Approval> transformToApproval(Collection<org.springframework.security.oauth2.provider.approval.Approval> approvals) {
        ArrayList<Approval> result = new ArrayList<Approval>();
        for (org.springframework.security.oauth2.provider.approval.Approval app : approvals) {
            result.add(new Approval(app.getExpiresAt(), "" + app.getStatus(), app.getLastUpdatedAt(), app.getUserId(), app.getClientId(), app.getScope()));
        }
        return result;
    }

    public void revokeApprovals(Collection<org.springframework.security.oauth2.provider.approval.Approval> approvals) {
        Collection<Approval> tmpApprovals = this.transformToApproval(approvals);
        for (Approval mongoApproval : tmpApprovals) {
            if (this.handleRevocationsAsExpiry) {
                this.approvalRepositorySql.updateExpiresAt(new Date(), mongoApproval);
                continue;
            }
            this.approvalRepositorySql.deleteByUserIdAndClientIdAndScope(mongoApproval);
        }
    }

    public Collection<org.springframework.security.oauth2.provider.approval.Approval> getApprovals(String userId, String clientId) {
        List<Approval> approvals = this.approvalRepositorySql.findByUserIdAndClientId(userId, clientId);
        return this.transformToSecurityApprovals(approvals);
    }

    private Collection<org.springframework.security.oauth2.provider.approval.Approval> transformToSecurityApprovals(List<Approval> approvals) {
        ArrayList<org.springframework.security.oauth2.provider.approval.Approval> result = new ArrayList<org.springframework.security.oauth2.provider.approval.Approval>();
        for (Approval app : approvals) {
            Approval.ApprovalStatus status = app.getStatus().equals(Approval.ApprovalStatus.APPROVED.toString()) ? Approval.ApprovalStatus.APPROVED : Approval.ApprovalStatus.DENIED;
            result.add(new org.springframework.security.oauth2.provider.approval.Approval(app.getUserId(), app.getClientId(), app.getScope(), app.getExpiresAt(), status, app.getLastModifiedAt()));
        }
        return result;
    }

    public OAuth2Authentication readAuthentication(String token) {
        String tokenId = this.extractTokenKey(token);
        AccessToken accessToken = this.accessTokenRepositorySql.findByTokenId(tokenId);
        if (Objects.nonNull(accessToken)) {
            try {
                return this.deserializeAuthentication(accessToken.getAuthentication());
            }
            catch (IllegalArgumentException e) {
                this.removeAccessToken(token);
            }
        }
        return null;
    }

    public void storeAccessToken(OAuth2AccessToken token, OAuth2Authentication authentication, AuthenticationKeyGenerator authenticationKeyGenerator) {
        String refreshToken = null;
        if (Objects.nonNull(token.getRefreshToken())) {
            refreshToken = token.getRefreshToken().getValue();
        }
        if (Objects.nonNull(this.readAccessToken(token.getValue()))) {
            this.removeAccessToken(token.getValue());
        }
        String tokenKey = this.extractTokenKey(token.getValue());
        AccessToken oAuth2AccessToken = new AccessToken(tokenKey, this.serializeAccessToken(token), authenticationKeyGenerator.extractKey(authentication), authentication.isClientOnly() ? null : authentication.getName(), authentication.getOAuth2Request().getClientId(), this.serializeAuthentication(authentication), this.extractTokenKey(refreshToken));
        this.accessTokenRepositorySql.save(oAuth2AccessToken);
    }

    public OAuth2AccessToken readAccessToken(String tokenValue) {
        String tokenKey = this.extractTokenKey(tokenValue);
        AccessToken AccessToken2 = this.accessTokenRepositorySql.findByToken(tokenKey);
        if (Objects.nonNull(AccessToken2)) {
            try {
                return this.deserializeAccessToken(AccessToken2.getToken());
            }
            catch (IllegalArgumentException e) {
                this.removeAccessToken(tokenValue);
            }
        }
        return null;
    }

    public void removeAccessToken(OAuth2AccessToken token) {
        this.removeAccessToken(token.getValue());
    }

    public void storeRefreshToken(OAuth2RefreshToken refreshToken, OAuth2Authentication oAuth2Authentication) {
        String tokenKey = this.extractTokenKey(refreshToken.getValue());
        byte[] token = this.serializeRefreshToken(refreshToken);
        byte[] authentication = this.serializeAuthentication(oAuth2Authentication);
        RefreshToken oAuth2RefreshToken = new RefreshToken(tokenKey, token, authentication);
        this.refreshTokenRepositorySql.save(oAuth2RefreshToken);
    }

    public OAuth2RefreshToken readRefreshToken(String tokenValue) {
        String tokenKey = this.extractTokenKey(tokenValue);
        RefreshToken refreshToken = this.refreshTokenRepositorySql.findByTokenId(tokenKey);
        if (Objects.nonNull(refreshToken)) {
            try {
                return this.deserializeRefreshToken(refreshToken.getToken());
            }
            catch (IllegalArgumentException e) {
                this.removeRefreshToken(tokenValue);
            }
        }
        return null;
    }

    public OAuth2Authentication readAuthenticationForRefreshToken(OAuth2RefreshToken token) {
        return this.readAuthenticationForRefreshToken(token.getValue());
    }

    public void removeRefreshToken(OAuth2RefreshToken token) {
        this.removeRefreshToken(token.getValue());
    }

    public void removeAccessTokenUsingRefreshToken(OAuth2RefreshToken refreshToken) {
        this.removeAccessTokenUsingRefreshToken(refreshToken.getValue());
    }

    public OAuth2AccessToken getAccessToken(OAuth2Authentication authentication, AuthenticationKeyGenerator authenticationKeyGenerator) {
        OAuth2AccessToken accessToken = null;
        String key = authenticationKeyGenerator.extractKey(authentication);
        AccessToken oAuth2AccessToken = this.accessTokenRepositorySql.findByAuthenticationId(key);
        if (oAuth2AccessToken != null) {
            accessToken = this.deserializeAccessToken(oAuth2AccessToken.getToken());
        }
        if (accessToken != null && !key.equals(authenticationKeyGenerator.extractKey(this.readAuthentication(accessToken.getValue())))) {
            this.removeAccessToken(accessToken.getValue());
            this.storeAccessToken(accessToken, authentication, authenticationKeyGenerator);
        }
        return accessToken;
    }

    public Collection<OAuth2AccessToken> findTokensByClientIdAndUserName(String clientId, String userName) {
        List<AccessToken> oAuth2AccessTokens = this.accessTokenRepositorySql.findByUsernameAndClientId(userName, clientId);
        return this.transformToOAuth2AccessTokens(oAuth2AccessTokens);
    }

    public Collection<OAuth2AccessToken> findTokensByClientId(String clientId) {
        List<AccessToken> oAuth2AccessTokens = this.accessTokenRepositorySql.findByClientId(clientId);
        return this.transformToOAuth2AccessTokens(oAuth2AccessTokens);
    }

    protected String extractTokenKey(String value) {
        MessageDigest digest;
        if (Objects.isNull(value)) {
            return null;
        }
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MD5 algorithm not available.  Fatal (should be in the JDK).");
        }
        try {
            byte[] bytes = digest.digest(value.getBytes("UTF-8"));
            return String.format("%032x", new BigInteger(1, bytes));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 encoding not available.  Fatal (should be in the JDK).");
        }
    }

    protected byte[] serializeAccessToken(OAuth2AccessToken token) {
        return SerializationUtils.serialize((Object)token);
    }

    protected byte[] serializeRefreshToken(OAuth2RefreshToken token) {
        return SerializationUtils.serialize((Object)token);
    }

    protected byte[] serializeAuthentication(OAuth2Authentication authentication) {
        return SerializationUtils.serialize((Object)authentication);
    }

    protected OAuth2AccessToken deserializeAccessToken(byte[] token) {
        return (OAuth2AccessToken)SerializationUtils.deserialize((byte[])token);
    }

    protected OAuth2RefreshToken deserializeRefreshToken(byte[] token) {
        return (OAuth2RefreshToken)SerializationUtils.deserialize((byte[])token);
    }

    protected OAuth2Authentication deserializeAuthentication(byte[] authentication) {
        return (OAuth2Authentication)SerializationUtils.deserialize((byte[])authentication);
    }

    public OAuth2Authentication readAuthenticationForRefreshToken(String value) {
        String tokenId = this.extractTokenKey(value);
        RefreshToken mongoOAuth2RefreshToken = this.refreshTokenRepositorySql.findByTokenId(tokenId);
        if (Objects.nonNull(mongoOAuth2RefreshToken)) {
            try {
                return this.deserializeAuthentication(mongoOAuth2RefreshToken.getAuthentication());
            }
            catch (IllegalArgumentException e) {
                this.removeRefreshToken(value);
            }
        }
        return null;
    }

    private void removeRefreshToken(String token) {
        String tokenId = this.extractTokenKey(token);
        this.refreshTokenRepositorySql.deleteByTokenId(tokenId);
    }

    private void removeAccessTokenUsingRefreshToken(String refreshToken) {
        String tokenId = this.extractTokenKey(refreshToken);
        this.accessTokenRepositorySql.deleteByRefreshTokenId(tokenId);
    }

    private void removeAccessToken(String tokenValue) {
        String tokenKey = this.extractTokenKey(tokenValue);
        this.accessTokenRepositorySql.deleteByTokenId(tokenKey);
    }

    private Collection<OAuth2AccessToken> transformToOAuth2AccessTokens(List<AccessToken> oAuth2AccessTokens) {
        return oAuth2AccessTokens.stream().filter(Objects::nonNull).map(token -> (OAuth2AccessToken)SerializationUtils.deserialize((byte[])token.getToken())).collect(Collectors.toList());
    }

    public void addClientDetails(ClientDetails clientDetails) {
    }

    public void updateClientDetails(ClientDetails clientDetails) {
    }

    public void updateClientSecret(String clientId, String secret) {
    }

    public void removeClientDetails(String clientId) {
    }

    public List<ClientDetails> listClientDetails() {
        return null;
    }

    public ClientDetails loadClientByClientId(String clientId) {
        return null;
    }

    public void initializeCurrentSession() throws Exception {
    }
}

