/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.store.sql.repository;

import br.com.anteros.persistence.parameter.NamedParameter;
import br.com.anteros.persistence.session.SQLSessionFactory;
import br.com.anteros.persistence.session.repository.impl.GenericSQLRepository;
import br.com.anteros.security.model.AccessToken;
import br.com.anteros.security.store.exception.AnterosSecurityStoreException;
import br.com.anteros.security.store.sql.repository.AccessTokenRepository;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Repository;

@Repository(value="accessTokenRepositorySql")
@Scope(value="prototype")
public class AccessTokenRepositoryImpl
extends GenericSQLRepository<AccessToken, Long>
implements AccessTokenRepository {
    @Autowired
    public AccessTokenRepositoryImpl(@Qualifier(value="securitySessionFactory") SQLSessionFactory sessionFactory) throws Exception {
        super(sessionFactory);
    }

    @Override
    public AccessToken findByToken(String tokenKey) {
        AccessToken accessToken = (AccessToken)this.findOneBySql("select tk.* from TOKEN_ACESSO tk where tk.TOKEN_ID = :PTOKEN_ID", new NamedParameter("PTOKEN_ID", (Object)tokenKey));
        return accessToken;
    }

    @Override
    public AccessToken findByAuthenticationId(String key) {
        AccessToken accessToken = (AccessToken)this.findOneBySql("select tk.* from TOKEN_ACESSO tk where tk.AUTENTICACAO_ID = :PAUTENTICACAO_ID", new NamedParameter("PAUTENTICACAO_ID", (Object)key));
        return accessToken;
    }

    @Override
    public List<AccessToken> findByUsernameAndClientId(String userName, String clientId) {
        List result = this.find("select tk.* from TOKEN_ACESSO tk where tk.USUARIO = :PUSUARIO AND tk.CLIENT_ID = :PCLIENT_ID", NamedParameter.list().addParameter("PUSUARIO", (Object)userName).addParameter("PCLIENT_ID", (Object)clientId));
        return result;
    }

    @Override
    public List<AccessToken> findByClientId(String clientId) {
        List result = this.find("select tk.* from TOKEN_ACESSO tk where tk.CLIENT_ID = :PCLIENT_ID", NamedParameter.list().addParameter("PCLIENT_ID", (Object)clientId));
        return result;
    }

    @Override
    public void deleteByRefreshTokenId(String tokenId) {
        AccessToken accessToken = (AccessToken)this.findOneBySql("select tk.* from TOKEN_ACESSO tk where tk.REFRESH_TOKEN = :PREFRESH_TOKEN", new NamedParameter("PREFRESH_TOKEN", (Object)tokenId));
        this.remove(accessToken);
    }

    @Override
    public void deleteByTokenId(String tokenKey) {
        try {
            this.getSession().getTransaction().begin();
            AccessToken accessToken = this.findByTokenId(tokenKey);
            if (accessToken != null) {
                this.remove(accessToken);
            }
            this.getSession().getTransaction().commit();
        }
        catch (Exception e) {
            try {
                this.getSession().getTransaction().rollback();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            throw new AnterosSecurityStoreException((Throwable)e);
        }
    }

    @Override
    public AccessToken findByTokenId(String tokenId) {
        AccessToken accessToken = (AccessToken)this.findOneBySql("select tk.* from TOKEN_ACESSO tk where tk.TOKEN_ID = :PTOKEN_ID", new NamedParameter("PTOKEN_ID", (Object)tokenId));
        return accessToken;
    }
}

