/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.store.sql.repository;

import br.com.anteros.persistence.parameter.NamedParameter;
import br.com.anteros.persistence.session.SQLSessionFactory;
import br.com.anteros.persistence.session.repository.impl.GenericSQLRepository;
import br.com.anteros.security.model.Resource;
import br.com.anteros.security.model.System;
import br.com.anteros.security.store.domain.IResource;
import br.com.anteros.security.store.domain.ISystem;
import br.com.anteros.security.store.exception.AnterosSecurityStoreException;
import br.com.anteros.security.store.sql.repository.ResourceRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Repository;

@Repository(value="resourceRepositorySql")
@Scope(value="prototype")
public class ResourceRepositoryImpl
extends GenericSQLRepository<Resource, Long>
implements ResourceRepository {
    @Autowired
    public ResourceRepositoryImpl(@Qualifier(value="securitySessionFactory") SQLSessionFactory sessionFactory) throws Exception {
        super(sessionFactory);
    }

    @Override
    public Resource getResourceByName(String systemName, String resourceName) {
        Resource resource = (Resource)this.findOneBySql("select rec.* from SEGURANCARECURSO rec, SEGURANCASISTEMA sis where sis.nome_sistema = :pnome_sistema and rec.nome_recurso = :pnome_recurso and rec.id_sistema = sis.id_sistema ", NamedParameter.list().addParameter("pnome_sistema", (Object)systemName).addParameter("pnome_recurso", (Object)resourceName).values());
        return resource;
    }

    @Override
    public Resource addResource(ISystem system, String resourceName, String description) {
        Resource resource = Resource.of(resourceName, description, (System)system);
        try {
            this.getSession().getTransaction().begin();
            this.getSession().save((Object)resource);
            this.getSession().getTransaction().commit();
        }
        catch (Exception e) {
            try {
                this.getSession().getTransaction().rollback();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            throw new AnterosSecurityStoreException("N\u00e3o foi poss\u00edvel salvar o recurso " + resourceName + ". " + e.getMessage(), (Throwable)e);
        }
        return resource;
    }

    @Override
    public Resource refreshResource(IResource resource) {
        this.refresh((Resource)resource);
        return (Resource)resource;
    }
}

