/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.model;

import br.com.anteros.persistence.metadata.annotation.Column;
import br.com.anteros.persistence.metadata.annotation.Entity;
import br.com.anteros.persistence.metadata.annotation.Fetch;
import br.com.anteros.persistence.metadata.annotation.GeneratedValue;
import br.com.anteros.persistence.metadata.annotation.Id;
import br.com.anteros.persistence.metadata.annotation.Index;
import br.com.anteros.persistence.metadata.annotation.Indexes;
import br.com.anteros.persistence.metadata.annotation.SequenceGenerator;
import br.com.anteros.persistence.metadata.annotation.Table;
import br.com.anteros.persistence.metadata.annotation.type.FetchMode;
import br.com.anteros.persistence.metadata.annotation.type.FetchType;
import br.com.anteros.persistence.metadata.annotation.type.GeneratedType;
import br.com.anteros.security.model.Resource;
import br.com.anteros.security.store.domain.ISystem;
import java.io.Serializable;
import java.util.Set;

@Entity
@Table(name="SEGURANCASISTEMA")
@Indexes(value={@Index(name="UK_SEGURANCASISTEMA_NOME_SIST", columnNames={"NOME_SISTEMA"}, unique=true)})
public class System
implements Serializable,
ISystem {
    @Id
    @Column(name="ID_SISTEMA", length=8)
    @GeneratedValue(strategy=GeneratedType.AUTO)
    @SequenceGenerator(sequenceName="SEQ_SISTEMA", initialValue=1)
    private Long id;
    @Column(name="NOME_SISTEMA", length=40, required=true)
    private String nome;
    @Column(name="DS_SISTEMA", length=40, required=true)
    private String descricao;
    @Column(name="VERSAO_MINIMA", length=20, required=true)
    private String versaoMinima;
    @Fetch(type=FetchType.LAZY, mode=FetchMode.ONE_TO_MANY, mappedBy="sistema")
    private Set<Resource> recursos;

    public System() {
    }

    public System(String nome, String descricao) {
        this.nome = nome;
        this.descricao = descricao;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getVersaoMinima() {
        return this.versaoMinima;
    }

    public void setVersaoMinima(String versaoMinima) {
        this.versaoMinima = versaoMinima;
    }

    public Set<Resource> getRecursos() {
        return this.recursos;
    }

    public void setRecursos(Set<Resource> recursos) {
        this.recursos = recursos;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.descricao == null ? 0 : this.descricao.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.nome == null ? 0 : this.nome.hashCode());
        result = 31 * result + (this.versaoMinima == null ? 0 : this.versaoMinima.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        System other = (System)obj;
        if (this.descricao == null ? other.descricao != null : !this.descricao.equals(other.descricao)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.nome == null ? other.nome != null : !this.nome.equals(other.nome)) {
            return false;
        }
        return !(this.versaoMinima == null ? other.versaoMinima != null : !this.versaoMinima.equals(other.versaoMinima));
    }

    public String getSystemId() {
        return this.getId() + "";
    }

    public String getSystemName() {
        return this.getNome();
    }

    public static System of(String systemName, String description) {
        return new System(systemName, description);
    }
}

