/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.model;

import br.com.anteros.persistence.metadata.annotation.BooleanValue;
import br.com.anteros.persistence.metadata.annotation.Column;
import br.com.anteros.persistence.metadata.annotation.DiscriminatorValue;
import br.com.anteros.persistence.metadata.annotation.Entity;
import br.com.anteros.persistence.metadata.annotation.Fetch;
import br.com.anteros.persistence.metadata.annotation.ForeignKey;
import br.com.anteros.persistence.metadata.annotation.JoinColumn;
import br.com.anteros.persistence.metadata.annotation.JoinTable;
import br.com.anteros.persistence.metadata.annotation.Transient;
import br.com.anteros.persistence.metadata.annotation.type.BooleanType;
import br.com.anteros.persistence.metadata.annotation.type.FetchMode;
import br.com.anteros.persistence.metadata.annotation.type.FetchType;
import br.com.anteros.security.model.AccessTime;
import br.com.anteros.security.model.Group;
import br.com.anteros.security.model.Profile;
import br.com.anteros.security.model.Security;
import java.util.List;

@Entity
@DiscriminatorValue(value="USUARIO")
public class User
extends Security {
    @Column(name="LOGIN", length=20)
    private String login;
    @Column(name="SENHA", length=100)
    private String senha;
    @BooleanValue(trueValue="S", falseValue="N", type=BooleanType.STRING)
    @Column(name="BO_ALTERAR_SENHA_PROX_LOGIN", required=true, defaultValue="'N'")
    private Boolean alterarSenhaProximoLogin;
    @BooleanValue(trueValue="S", falseValue="N", type=BooleanType.STRING)
    @Column(name="BO_PERMITE_ALTERAR_SENHA", required=true, defaultValue="'N'")
    private Boolean permiteAlterarSenha;
    @BooleanValue(trueValue="S", falseValue="N", type=BooleanType.STRING)
    @Column(name="BO_PERMITE_MULTIPLOS_LOGINS", required=true, defaultValue="'N'")
    private Boolean permiteMultiplosLogins;
    @BooleanValue(trueValue="S", falseValue="N", type=BooleanType.STRING)
    @Column(name="BO_SENHA_NUNCA_EXPIRA", required=true, defaultValue="'N'")
    private Boolean senhaNuncaExpira;
    @BooleanValue(trueValue="S", falseValue="N", type=BooleanType.STRING)
    @Column(name="BO_CONTA_DESATIVADA", required=true, defaultValue="'N'")
    private Boolean contaDesativada = Boolean.FALSE;
    @BooleanValue(trueValue="S", falseValue="N", type=BooleanType.STRING)
    @Column(name="BO_CONTA_BLOQUEADA", required=true, defaultValue="'N'")
    private Boolean contaBloqueada = Boolean.FALSE;
    @BooleanValue(falseValue="N", trueValue="S", type=BooleanType.STRING)
    @Column(name="BO_HORARIO_LIVRE", length=1, required=true, defaultValue="'N'")
    private Boolean boHorarioLivre;
    @BooleanValue(falseValue="N", trueValue="S", type=BooleanType.STRING)
    @Column(name="BO_ADMINISTRADOR", length=1, required=true, defaultValue="'N'")
    private Boolean boAdministrador;
    @ForeignKey(type=FetchType.EAGER)
    @Column(name="ID_HORARIO", inversedColumn="ID_HORARIO")
    private AccessTime horarioAcesso;
    @Fetch(type=FetchType.LAZY, mode=FetchMode.MANY_TO_MANY)
    @JoinTable(name="SEGURANCAGRUPOMEMBRO", joinColumns={@JoinColumn(name="ID_USUARIO", referencedColumnName="ID_SEGURANCA")}, inversedJoinColumns={@JoinColumn(name="ID_GRUPO", referencedColumnName="ID_SEGURANCA")})
    private List<Group> grupos;
    @ForeignKey(type=FetchType.EAGER)
    @Column(name="ID_PERFIL", inversedColumn="ID_SEGURANCA")
    private Profile perfil;

    public Boolean getAlterarSenhaProximoLogin() {
        return this.alterarSenhaProximoLogin;
    }

    public void setAlterarSenhaProximoLogin(Boolean alterarSenhaProximoLogin) {
        this.alterarSenhaProximoLogin = alterarSenhaProximoLogin;
    }

    public Boolean getPermiteAlterarSenha() {
        return this.permiteAlterarSenha;
    }

    public void setPermiteAlterarSenha(Boolean permiteAlterarSenha) {
        this.permiteAlterarSenha = permiteAlterarSenha;
    }

    public Boolean getSenhaNuncaExpira() {
        return this.senhaNuncaExpira;
    }

    public void setSenhaNuncaExpira(Boolean senhaNuncaExpira) {
        this.senhaNuncaExpira = senhaNuncaExpira;
    }

    public Boolean getContaDesativada() {
        return this.contaDesativada;
    }

    public void setContaDesativada(Boolean contaDesativada) {
        this.contaDesativada = contaDesativada;
    }

    public Boolean getContaBloqueada() {
        return this.contaBloqueada;
    }

    public void setContaBloqueada(Boolean contaBloqueada) {
        this.contaBloqueada = contaBloqueada;
    }

    public Boolean getPermiteMultiplosLogins() {
        return this.permiteMultiplosLogins;
    }

    public void setPermiteMultiplosLogins(Boolean permiteMultiplosLogins) {
        this.permiteMultiplosLogins = permiteMultiplosLogins;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public List<Group> getGrupos() {
        return this.grupos;
    }

    public void setGrupos(List<Group> grupos) {
        this.grupos = grupos;
    }

    public Profile getPerfil() {
        return this.perfil;
    }

    public void setPerfil(Profile perfil) {
        this.perfil = perfil;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    @Transient
    public boolean isExpirada() {
        return this.contaBloqueada != false || this.contaDesativada != false;
    }

    public Boolean getBoHorarioLivre() {
        return this.boHorarioLivre;
    }

    public void setBoHorarioLivre(Boolean boHorarioLivre) {
        this.boHorarioLivre = boHorarioLivre;
    }

    public Boolean getBoAdministrador() {
        return this.boAdministrador;
    }

    public void setBoAdministrador(Boolean boAdministrador) {
        this.boAdministrador = boAdministrador;
    }

    public AccessTime getHorarioAcesso() {
        return this.horarioAcesso;
    }

    public void setHorarioAcesso(AccessTime horarioAcesso) {
        this.horarioAcesso = horarioAcesso;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.login == null ? 0 : this.login.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return !(this.login == null ? other.login != null : !this.login.equals(other.login));
    }
}

