/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.model;

import br.com.anteros.persistence.metadata.annotation.Cascade;
import br.com.anteros.persistence.metadata.annotation.Column;
import br.com.anteros.persistence.metadata.annotation.Entity;
import br.com.anteros.persistence.metadata.annotation.Fetch;
import br.com.anteros.persistence.metadata.annotation.ForeignKey;
import br.com.anteros.persistence.metadata.annotation.GeneratedValue;
import br.com.anteros.persistence.metadata.annotation.Id;
import br.com.anteros.persistence.metadata.annotation.Index;
import br.com.anteros.persistence.metadata.annotation.Indexes;
import br.com.anteros.persistence.metadata.annotation.SequenceGenerator;
import br.com.anteros.persistence.metadata.annotation.Table;
import br.com.anteros.persistence.metadata.annotation.type.CascadeType;
import br.com.anteros.persistence.metadata.annotation.type.FetchMode;
import br.com.anteros.persistence.metadata.annotation.type.FetchType;
import br.com.anteros.persistence.metadata.annotation.type.GeneratedType;
import br.com.anteros.security.model.Action;
import br.com.anteros.security.model.System;
import java.io.Serializable;
import java.util.List;

@Entity
@Table(name="SEGURANCARECURSO")
@Indexes(value={@Index(name="UK_SEGURANCARECURSO_NOME_RECUR", columnNames={"ID_SISTEMA, NOME_RECURSO"}, unique=true)})
public class Resource
implements Serializable {
    @Id
    @Column(name="ID_RECURSO", length=8)
    @GeneratedValue(strategy=GeneratedType.AUTO)
    @SequenceGenerator(sequenceName="SEQ_SEGURANCARECURSO", initialValue=1)
    private Long id;
    @Column(name="NOME_RECURSO", length=40, required=true)
    private String nome;
    @Column(name="DS_RECURSO", length=40, required=true)
    private String descricao;
    @Fetch(type=FetchType.LAZY, mode=FetchMode.ONE_TO_MANY, mappedBy="recurso")
    @Cascade(values={CascadeType.DELETE_ORPHAN})
    private List<Action> acoes;
    @ForeignKey(type=FetchType.EAGER)
    @Column(name="ID_SISTEMA", inversedColumn="ID_SISTEMA")
    private System sistema;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public List<Action> getAcoes() {
        return this.acoes;
    }

    public void setAcoes(List<Action> acoes) {
        this.acoes = acoes;
    }

    public System getSistema() {
        return this.sistema;
    }

    public void setSistema(System sistema) {
        this.sistema = sistema;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.descricao == null ? 0 : this.descricao.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.nome == null ? 0 : this.nome.hashCode());
        result = 31 * result + (this.sistema == null ? 0 : this.sistema.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        if (this.descricao == null ? other.descricao != null : !this.descricao.equals(other.descricao)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.nome == null ? other.nome != null : !this.nome.equals(other.nome)) {
            return false;
        }
        return !(this.sistema == null ? other.sistema != null : !this.sistema.equals(other.sistema));
    }
}

