/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.store.sql.domain;

import br.com.anteros.persistence.metadata.annotation.BooleanValue;
import br.com.anteros.persistence.metadata.annotation.Column;
import br.com.anteros.persistence.metadata.annotation.DiscriminatorValue;
import br.com.anteros.persistence.metadata.annotation.Entity;
import br.com.anteros.persistence.metadata.annotation.Fetch;
import br.com.anteros.persistence.metadata.annotation.ForeignKey;
import br.com.anteros.persistence.metadata.annotation.JoinColumn;
import br.com.anteros.persistence.metadata.annotation.JoinTable;
import br.com.anteros.persistence.metadata.annotation.Lob;
import br.com.anteros.persistence.metadata.annotation.type.BooleanType;
import br.com.anteros.persistence.metadata.annotation.type.FetchMode;
import br.com.anteros.persistence.metadata.annotation.type.FetchType;
import br.com.anteros.security.store.domain.IAction;
import br.com.anteros.security.store.domain.IProfile;
import br.com.anteros.security.store.domain.IUser;
import br.com.anteros.security.store.sql.domain.AccessTime;
import br.com.anteros.security.store.sql.domain.Action;
import br.com.anteros.security.store.sql.domain.Group;
import br.com.anteros.security.store.sql.domain.Profile;
import br.com.anteros.security.store.sql.domain.Security;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Entity
@DiscriminatorValue(value="USUARIO")
public class User
extends Security
implements IUser {
    @Column(name="LOGIN", length=20)
    private String login;
    @Column(name="SENHA", length=100)
    private String password;
    @BooleanValue(trueValue="S", falseValue="N", type=BooleanType.STRING)
    @Column(name="BO_ALTERAR_SENHA_PROX_LOGIN", required=true, defaultValue="'N'")
    private Boolean changePasswordOnNextLogin;
    @BooleanValue(trueValue="S", falseValue="N", type=BooleanType.STRING)
    @Column(name="BO_PERMITE_ALTERAR_SENHA", required=true, defaultValue="'N'")
    private Boolean allowChangePassword;
    @BooleanValue(trueValue="S", falseValue="N", type=BooleanType.STRING)
    @Column(name="BO_PERMITE_MULTIPLOS_LOGINS", required=true, defaultValue="'N'")
    private Boolean allowMultipleLogins;
    @BooleanValue(trueValue="S", falseValue="N", type=BooleanType.STRING)
    @Column(name="BO_SENHA_NUNCA_EXPIRA", required=true, defaultValue="'N'")
    private Boolean passwordNeverExpire;
    @BooleanValue(trueValue="S", falseValue="N", type=BooleanType.STRING)
    @Column(name="BO_CONTA_DESATIVADA", required=true, defaultValue="'N'")
    private Boolean inactiveAccount = Boolean.FALSE;
    @BooleanValue(trueValue="S", falseValue="N", type=BooleanType.STRING)
    @Column(name="BO_CONTA_BLOQUEADA", required=true, defaultValue="'N'")
    private Boolean blockedAccount = Boolean.FALSE;
    @BooleanValue(falseValue="N", trueValue="S", type=BooleanType.STRING)
    @Column(name="BO_HORARIO_LIVRE", length=1, required=true, defaultValue="'N'")
    private Boolean boFreeAccessTime;
    @BooleanValue(falseValue="N", trueValue="S", type=BooleanType.STRING)
    @Column(name="BO_ADMINISTRADOR", length=1, required=true, defaultValue="'N'")
    private Boolean boAdministrator;
    @Lob
    @Column(name="AVATAR")
    private String avatar;
    @ForeignKey(type=FetchType.EAGER)
    @Column(name="ID_HORARIO", inversedColumn="ID_HORARIO")
    private AccessTime accessTime;
    @Fetch(type=FetchType.LAZY, mode=FetchMode.MANY_TO_MANY)
    @JoinTable(name="SEGURANCAGRUPOMEMBRO", joinColumns={@JoinColumn(name="ID_USUARIO", referencedColumnName="ID_SEGURANCA")}, inversedJoinColumns={@JoinColumn(name="ID_GRUPO", referencedColumnName="ID_SEGURANCA")})
    private List<Group> groups;
    @ForeignKey(type=FetchType.EAGER)
    @Column(name="ID_PERFIL", inversedColumn="ID_SEGURANCA")
    private Profile profile;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.login == null ? 0 : this.login.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return !(this.login == null ? other.login != null : !this.login.equals(other.login));
    }

    public boolean isPasswordNeverExpire() {
        return this.passwordNeverExpire;
    }

    public boolean isInactiveAccount() {
        return this.inactiveAccount;
    }

    public boolean isBlockedAccount() {
        return this.blockedAccount;
    }

    public boolean isAdministrator() {
        return this.boAdministrator;
    }

    public Set<IAction> getActionList() {
        HashSet<IAction> result = new HashSet<IAction>();
        for (Action action : this.getActions()) {
            result.add(action);
        }
        return result;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Boolean getChangePasswordOnNextLogin() {
        return this.changePasswordOnNextLogin;
    }

    public void setChangePasswordOnNextLogin(Boolean changePasswordOnNextLogin) {
        this.changePasswordOnNextLogin = changePasswordOnNextLogin;
    }

    public Boolean getAllowChangePassword() {
        return this.allowChangePassword;
    }

    public void setAllowChangePassword(Boolean allowChangePassword) {
        this.allowChangePassword = allowChangePassword;
    }

    public Boolean getAllowMultipleLogins() {
        return this.allowMultipleLogins;
    }

    public void setAllowMultipleLogins(Boolean allowMultipleLogins) {
        this.allowMultipleLogins = allowMultipleLogins;
    }

    public Boolean getPasswordNeverExpire() {
        return this.passwordNeverExpire;
    }

    public void setPasswordNeverExpire(Boolean passwordNeverExpire) {
        this.passwordNeverExpire = passwordNeverExpire;
    }

    public Boolean getInactiveAccount() {
        return this.inactiveAccount;
    }

    public void setInactiveAccount(Boolean inactiveAccount) {
        this.inactiveAccount = inactiveAccount;
    }

    public Boolean getBlockedAccount() {
        return this.blockedAccount;
    }

    public void setBlockedAccount(Boolean blockedAccount) {
        this.blockedAccount = blockedAccount;
    }

    public Boolean getBoFreeAccessTime() {
        return this.boFreeAccessTime;
    }

    public void setBoFreeAccessTime(Boolean boFreeAccessTime) {
        this.boFreeAccessTime = boFreeAccessTime;
    }

    public Boolean getBoAdministrator() {
        return this.boAdministrator;
    }

    public void setBoAdministrator(Boolean boAdministrator) {
        this.boAdministrator = boAdministrator;
    }

    public AccessTime getAccessTime() {
        return this.accessTime;
    }

    public void setAccessTime(AccessTime accessTime) {
        this.accessTime = accessTime;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    public IProfile getUserProfile() {
        return (IProfile)this.profile;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getUserId() {
        return this.getId() + "";
    }
}

