/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.store.sql.domain;

import br.com.anteros.persistence.metadata.annotation.Column;
import br.com.anteros.persistence.metadata.annotation.Entity;
import br.com.anteros.persistence.metadata.annotation.Fetch;
import br.com.anteros.persistence.metadata.annotation.GeneratedValue;
import br.com.anteros.persistence.metadata.annotation.Id;
import br.com.anteros.persistence.metadata.annotation.Index;
import br.com.anteros.persistence.metadata.annotation.Indexes;
import br.com.anteros.persistence.metadata.annotation.SequenceGenerator;
import br.com.anteros.persistence.metadata.annotation.Table;
import br.com.anteros.persistence.metadata.annotation.type.FetchMode;
import br.com.anteros.persistence.metadata.annotation.type.FetchType;
import br.com.anteros.persistence.metadata.annotation.type.GeneratedType;
import br.com.anteros.security.store.domain.ISystem;
import br.com.anteros.security.store.sql.domain.Resource;
import java.io.Serializable;
import java.util.Set;

@Entity
@Table(name="SEGURANCASISTEMA")
@Indexes(value={@Index(name="UK_SEGURANCASISTEMA_NOME_SIST", columnNames={"NOME_SISTEMA"}, unique=true)})
public class System
implements Serializable,
ISystem {
    @Id
    @Column(name="ID_SISTEMA", length=8)
    @GeneratedValue(strategy=GeneratedType.AUTO)
    @SequenceGenerator(sequenceName="SEQ_SISTEMA", initialValue=1)
    private Long id;
    @Column(name="NOME_SISTEMA", length=40, required=true)
    private String name;
    @Column(name="DS_SISTEMA", length=40, required=true)
    private String description;
    @Column(name="VERSAO_MINIMA", length=20)
    private String minimalVersion;
    @Fetch(type=FetchType.LAZY, mode=FetchMode.ONE_TO_MANY, mappedBy="system")
    private Set<Resource> resources;

    public System() {
    }

    public System(String systemName, String description) {
        this.name = systemName;
        this.description = description;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getMinimalVersion() {
        return this.minimalVersion;
    }

    public void setMinimalVersion(String minimalVersion) {
        this.minimalVersion = minimalVersion;
    }

    public Set<Resource> getResources() {
        return this.resources;
    }

    public void setResources(Set<Resource> resources) {
        this.resources = resources;
    }

    public String getSystemName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.minimalVersion == null ? 0 : this.minimalVersion.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        System other = (System)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.minimalVersion == null ? other.minimalVersion != null : !this.minimalVersion.equals(other.minimalVersion)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.resources == null ? other.resources != null : !this.resources.equals(other.resources));
    }

    public static System of(String systemName, String description) {
        return new System(systemName, description);
    }

    public Long getId() {
        return this.id;
    }

    public String getSystemId() {
        return this.id + "";
    }
}

