/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.store.sql.repository;

import br.com.anteros.persistence.parameter.NamedParameter;
import br.com.anteros.persistence.session.SQLSessionFactory;
import br.com.anteros.persistence.session.repository.impl.GenericSQLRepository;
import br.com.anteros.security.store.domain.IAction;
import br.com.anteros.security.store.domain.IResource;
import br.com.anteros.security.store.domain.ISystem;
import br.com.anteros.security.store.exception.AnterosSecurityStoreException;
import br.com.anteros.security.store.sql.domain.Action;
import br.com.anteros.security.store.sql.repository.ActionRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Repository;

@Repository(value="actionRepositorySql")
@Scope(value="prototype")
public class ActionRepositoryImpl
extends GenericSQLRepository<Action, Long>
implements ActionRepository {
    @Autowired
    public ActionRepositoryImpl(@Qualifier(value="securitySessionFactory") SQLSessionFactory sessionFactory) throws Exception {
        super(sessionFactory);
    }

    @Override
    public Action addAction(ISystem system, IResource resource, String actionName, String category, String description, String version) {
        try {
            this.getSession().getTransaction().begin();
            Action action = Action.of(actionName, description, category, resource, version);
            this.getSession().save((Object)action);
            this.getSession().getTransaction().commit();
            return action;
        }
        catch (Exception e) {
            try {
                this.getSession().getTransaction().rollback();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            throw new AnterosSecurityStoreException("N\u00e3o foi poss\u00edvel salvar a a\u00e7\u00e3o " + actionName + ". " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void removeActionByAllUsers(IAction act) {
        try {
            this.getSession().getTransaction().begin();
            this.getSession().createQuery("delete from SEGURANCAACAOACAO where id_acao = :pid_acao", (Object)new NamedParameter("pid_acao", (Object)act.getId())).executeQuery();
            this.remove((Action)act);
            this.getSession().getTransaction().commit();
        }
        catch (Exception e) {
            try {
                this.getSession().getTransaction().rollback();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            throw new AnterosSecurityStoreException((Throwable)e);
        }
    }
}

