/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.store.sql.domain;

import br.com.anteros.persistence.metadata.annotation.Cascade;
import br.com.anteros.persistence.metadata.annotation.Column;
import br.com.anteros.persistence.metadata.annotation.Entity;
import br.com.anteros.persistence.metadata.annotation.Fetch;
import br.com.anteros.persistence.metadata.annotation.ForeignKey;
import br.com.anteros.persistence.metadata.annotation.GeneratedValue;
import br.com.anteros.persistence.metadata.annotation.Id;
import br.com.anteros.persistence.metadata.annotation.Index;
import br.com.anteros.persistence.metadata.annotation.Indexes;
import br.com.anteros.persistence.metadata.annotation.SequenceGenerator;
import br.com.anteros.persistence.metadata.annotation.Table;
import br.com.anteros.persistence.metadata.annotation.type.CascadeType;
import br.com.anteros.persistence.metadata.annotation.type.FetchMode;
import br.com.anteros.persistence.metadata.annotation.type.FetchType;
import br.com.anteros.persistence.metadata.annotation.type.GeneratedType;
import br.com.anteros.security.store.domain.IAction;
import br.com.anteros.security.store.domain.IResource;
import br.com.anteros.security.store.sql.domain.Action;
import br.com.anteros.security.store.sql.domain.System;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name="SEGURANCARECURSO")
@Indexes(value={@Index(name="UK_SEGURANCARECURSO_NOME_RECUR", columnNames={"ID_SISTEMA, NOME_RECURSO"}, unique=true)})
public class Resource
implements Serializable,
IResource {
    @Id
    @Column(name="ID_RECURSO", length=8)
    @GeneratedValue(strategy=GeneratedType.AUTO)
    @SequenceGenerator(sequenceName="SEQ_SEGURANCARECURSO", initialValue=1)
    private Long id;
    @Column(name="NOME_RECURSO", length=40, required=true)
    private String name;
    @Column(name="DS_RECURSO", length=40, required=true)
    private String description;
    @Fetch(type=FetchType.LAZY, mode=FetchMode.ONE_TO_MANY, mappedBy="resource")
    @Cascade(values={CascadeType.DELETE_ORPHAN})
    private List<Action> actions;
    @ForeignKey(type=FetchType.EAGER)
    @Column(name="ID_SISTEMA", inversedColumn="ID_SISTEMA")
    private System system;

    public Resource() {
    }

    public Resource(String resourceName, String description, System system) {
        this.name = resourceName;
        this.description = description;
        this.system = system;
    }

    public List<IAction> getActionList() {
        ArrayList<IAction> result = new ArrayList<IAction>();
        if (this.actions != null) {
            for (Action action : this.actions) {
                result.add(action);
            }
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.system == null ? 0 : this.system.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.system == null ? other.system != null : !this.system.equals(other.system));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public System getSystem() {
        return this.system;
    }

    public void setSystem(System system) {
        this.system = system;
    }

    public String getResourceName() {
        return this.name;
    }

    public static Resource of(String resourceName, String description, System system) {
        return new Resource(resourceName, description, system);
    }

    public String getId() {
        return "" + this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public IResource addAction(IAction action) {
        this.actions.add((Action)action);
        return this;
    }
}

