/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.store.sql.domain;

import br.com.anteros.persistence.metadata.annotation.BooleanValue;
import br.com.anteros.persistence.metadata.annotation.Column;
import br.com.anteros.persistence.metadata.annotation.Entity;
import br.com.anteros.persistence.metadata.annotation.ForeignKey;
import br.com.anteros.persistence.metadata.annotation.GeneratedValue;
import br.com.anteros.persistence.metadata.annotation.Id;
import br.com.anteros.persistence.metadata.annotation.SequenceGenerator;
import br.com.anteros.persistence.metadata.annotation.Table;
import br.com.anteros.persistence.metadata.annotation.type.BooleanType;
import br.com.anteros.persistence.metadata.annotation.type.FetchType;
import br.com.anteros.persistence.metadata.annotation.type.GeneratedType;
import br.com.anteros.security.store.domain.IAction;
import br.com.anteros.security.store.domain.IResource;
import br.com.anteros.security.store.sql.domain.Resource;
import java.io.Serializable;

@Entity
@Table(name="SEGURANCAACAO")
public class Action
implements Serializable,
IAction {
    @Id
    @Column(name="ID_ACAO", length=8)
    @GeneratedValue(strategy=GeneratedType.AUTO)
    @SequenceGenerator(sequenceName="SEQ_ACAO", initialValue=1)
    private Long id;
    @Column(name="ACAO", length=250, required=true)
    private String name;
    @Column(name="DS_ACAO", length=250, required=true)
    private String description;
    @ForeignKey(type=FetchType.EAGER)
    @Column(name="ID_RECURSO", inversedColumn="ID_RECURSO", required=true)
    private Resource resource;
    @Column(name="CATEGORIA", length=30, required=true)
    private String category;
    @BooleanValue(falseValue="N", trueValue="S", type=BooleanType.STRING)
    @Column(name="BO_ATIVA", length=1, required=true, defaultValue="'S'")
    private Boolean active;
    @Column(name="VERSAO", length=15, required=false, defaultValue="'0.0.0.0'")
    private String version;

    public Action() {
    }

    public Action(String actionName, String description, String category, IResource resource, String version) {
        this.name = actionName;
        this.description = description;
        this.category = category;
        this.resource = (Resource)resource;
        this.version = version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.active == null ? 0 : this.active.hashCode());
        result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Action other = (Action)obj;
        if (this.active == null ? other.active != null : !this.active.equals(other.active)) {
            return false;
        }
        if (this.category == null ? other.category != null : !this.category.equals(other.category)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.resource == null ? other.resource != null : !this.resource.equals(other.resource)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Boolean getActive() {
        if (this.active == null) {
            return true;
        }
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getActionName() {
        return this.name;
    }

    public boolean isActive() {
        if (this.active == null) {
            return true;
        }
        return this.active;
    }

    public void setActive(boolean value) {
        this.active = value;
    }

    public static Action of(String actionName, String description, String category, IResource resource, String version) {
        return new Action(actionName, description, category, resource, version);
    }

    public String getId() {
        return "" + this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}

