/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.spring.oauth2;

import br.com.anteros.security.store.SecurityDataStore;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.AuthenticationKeyGenerator;
import org.springframework.security.oauth2.provider.token.DefaultAuthenticationKeyGenerator;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.stereotype.Component;

@Component(value="tokenStore")
public class AnterosSecurityTokenStore
implements TokenStore {
    @Autowired
    private SecurityDataStore securityDataStore;
    private AuthenticationKeyGenerator authenticationKeyGenerator = new DefaultAuthenticationKeyGenerator();

    public OAuth2Authentication readAuthentication(OAuth2AccessToken token) {
        return this.readAuthentication(token.getValue());
    }

    public OAuth2Authentication readAuthentication(String token) {
        return this.securityDataStore.readAuthentication(token);
    }

    public void storeAccessToken(OAuth2AccessToken token, OAuth2Authentication authentication) {
        this.securityDataStore.storeAccessToken(token, authentication, this.authenticationKeyGenerator);
    }

    public OAuth2AccessToken readAccessToken(String tokenValue) {
        return this.securityDataStore.readAccessToken(tokenValue);
    }

    public void removeAccessToken(OAuth2AccessToken token) {
        this.securityDataStore.removeAccessToken(token);
    }

    public void storeRefreshToken(OAuth2RefreshToken refreshToken, OAuth2Authentication authentication) {
        this.securityDataStore.storeRefreshToken(refreshToken, authentication);
    }

    public OAuth2RefreshToken readRefreshToken(String tokenValue) {
        return this.securityDataStore.readRefreshToken(tokenValue);
    }

    public OAuth2Authentication readAuthenticationForRefreshToken(OAuth2RefreshToken token) {
        return this.securityDataStore.readAuthenticationForRefreshToken(token);
    }

    public void removeRefreshToken(OAuth2RefreshToken token) {
        this.securityDataStore.removeRefreshToken(token);
    }

    public void removeAccessTokenUsingRefreshToken(OAuth2RefreshToken refreshToken) {
        this.securityDataStore.removeAccessTokenUsingRefreshToken(refreshToken);
    }

    public OAuth2AccessToken getAccessToken(OAuth2Authentication authentication) {
        return this.securityDataStore.getAccessToken(authentication, this.authenticationKeyGenerator);
    }

    public Collection<OAuth2AccessToken> findTokensByClientIdAndUserName(String clientId, String userName) {
        return this.securityDataStore.findTokensByClientIdAndUserName(clientId, userName);
    }

    public Collection<OAuth2AccessToken> findTokensByClientId(String clientId) {
        return this.securityDataStore.findTokensByClientId(clientId);
    }

    public AuthenticationKeyGenerator getAuthenticationKeyGenerator() {
        return this.authenticationKeyGenerator;
    }

    public void setAuthenticationKeyGenerator(AuthenticationKeyGenerator authenticationKeyGenerator) {
        this.authenticationKeyGenerator = authenticationKeyGenerator;
    }
}

