/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.spring.config;

import br.com.anteros.security.spring.AnterosSecurityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.error.OAuth2AccessDeniedHandler;
import org.springframework.security.oauth2.provider.token.TokenStore;

@Configuration
@EnableAuthorizationServer
public abstract class AbstractSpringAuthServerOAuth2Configuration
extends AuthorizationServerConfigurerAdapter {
    @Autowired
    private TokenStore tokenStore;
    @Autowired
    private AnterosSecurityManager authenticationManager;

    public abstract PasswordEncoder getOAuth2ClientPasswordEncoder();

    @Bean
    public OAuth2AccessDeniedHandler oauthAccessDeniedHandler() {
        return new OAuth2AccessDeniedHandler();
    }

    public void configure(AuthorizationServerSecurityConfigurer oauthServer) {
        oauthServer.tokenKeyAccess("permitAll()").checkTokenAccess("isAuthenticated()").passwordEncoder(this.getOAuth2ClientPasswordEncoder());
    }

    public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
        System.out.println(this.getOAuth2ClientPasswordEncoder().encode((CharSequence)"senha_secreta"));
        clients.withClientDetails((ClientDetailsService)this.authenticationManager);
    }

    public void configure(AuthorizationServerEndpointsConfigurer endpoints) {
        endpoints.tokenStore(this.tokenStore).authenticationManager((AuthenticationManager)this.authenticationManager).userDetailsService((UserDetailsService)this.authenticationManager).allowedTokenEndpointRequestMethods(new HttpMethod[]{HttpMethod.GET, HttpMethod.POST});
    }
}

