/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.spring;

import br.com.anteros.core.log.Logger;
import br.com.anteros.core.log.LoggerProvider;
import br.com.anteros.core.utils.ArrayUtils;
import br.com.anteros.core.utils.ReflectionUtils;
import br.com.anteros.security.spring.ActionSecured;
import br.com.anteros.security.spring.AnterosSecurityGrantedAuthority;
import br.com.anteros.security.spring.AnterosSecurityUser;
import br.com.anteros.security.spring.ResourceSecured;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class AnterosSecurityVoter
implements AccessDecisionVoter<MethodInvocation> {
    private static final String EMPTY_SYSTEM = "no_system";
    private static final String EMPTY_RESOURCE = "no_resource";
    private static final String EMPTY_ACTION = "no_action";
    private static Logger LOG = LoggerProvider.getInstance().getLogger(AnterosSecurityVoter.class.getName());
    private String rolePrefix = "ACT_";

    public String getActionPrefix() {
        return this.rolePrefix;
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    public boolean supports(ConfigAttribute config) {
        return true;
    }

    public boolean supports(Class clazz) {
        return true;
    }

    public int vote(Authentication authentication, MethodInvocation object, Collection attributes) {
        int result = 0;
        if (authentication.getPrincipal() instanceof AnterosSecurityUser) {
            String systemName = EMPTY_SYSTEM;
            String resourceName = EMPTY_RESOURCE;
            String actionName = EMPTY_ACTION;
            AnterosSecurityUser principal = (AnterosSecurityUser)authentication.getPrincipal();
            if (!principal.isAdminNeedsPermission() && principal.isAdmin()) {
                return 1;
            }
            if (object instanceof ReflectiveMethodInvocation) {
                result = -1;
                Collection<? extends GrantedAuthority> authorities = this.extractAuthorities(authentication);
                for (Object attribute : attributes) {
                    ConfigAttribute configAttribute = (ConfigAttribute)attribute;
                    if (!this.supports(configAttribute)) continue;
                    result = -1;
                    systemName = principal.getSystemName();
                    resourceName = EMPTY_RESOURCE;
                    actionName = configAttribute.getAttribute();
                    boolean requiresAdmin = false;
                    Method method = ((ReflectiveMethodInvocation)object).getMethod();
                    Class<?> declaringClass = ((ReflectiveMethodInvocation)object).getThis().getClass();
                    List clazzes = ArrayUtils.asList((Object[])ReflectionUtils.getAllSuperClasses(declaringClass));
                    clazzes.addAll(ArrayUtils.asList((Object[])ReflectionUtils.getAllInterfaces(declaringClass)));
                    clazzes.add(declaringClass);
                    for (Class clazz : clazzes) {
                        if (!clazz.isAnnotationPresent(ResourceSecured.class)) continue;
                        ResourceSecured annotation = clazz.getAnnotation(ResourceSecured.class);
                        resourceName = annotation.resourceName();
                        break;
                    }
                    if (method.isAnnotationPresent(ActionSecured.class)) {
                        ActionSecured secured = method.getAnnotation(ActionSecured.class);
                        actionName = secured.actionName();
                        requiresAdmin = secured.requiresAdmin();
                    }
                    if (EMPTY_SYSTEM.equals(systemName) || EMPTY_RESOURCE.equals(resourceName) || EMPTY_ACTION.equalsIgnoreCase(actionName)) {
                        return -1;
                    }
                    if (requiresAdmin && !principal.isAdmin()) {
                        return -1;
                    }
                    for (GrantedAuthority grantedAuthority : authorities) {
                        if (!(grantedAuthority instanceof AnterosSecurityGrantedAuthority ? ((AnterosSecurityGrantedAuthority)grantedAuthority).equalsTo(systemName, resourceName, actionName) : ((SecurityConfig)attribute).getAttribute().equalsIgnoreCase(grantedAuthority.getAuthority()))) continue;
                        return 1;
                    }
                }
            } else {
                result = 1;
            }
            if (result == -1) {
                LOG.info((Object)("N\u00e3o foi encontrado acesso para o usu\u00e1rio '" + principal.getUsername() + "' no sistema '" + systemName + "', recurso '" + resourceName + "' e a\u00e7\u00e3o '" + actionName + "'"));
            }
        }
        return result;
    }

    Collection<? extends GrantedAuthority> extractAuthorities(Authentication authentication) {
        return authentication.getAuthorities();
    }
}

