/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.spring;

import br.com.anteros.core.utils.Assert;
import br.com.anteros.security.spring.AnterosSecurityManager;

public class AnterosSecurityManagerBuilder {
    private boolean adminNeedsPermission = false;
    private String packageToScanSecurity = "";
    private String systemName;
    private String version;
    private String description;

    public AnterosSecurityManagerBuilder adminNeedsPermission(boolean adminNeedsPermission) {
        this.adminNeedsPermission = adminNeedsPermission;
        return this;
    }

    public AnterosSecurityManagerBuilder packageToScanSecurity(String packageToScanSecurity) {
        this.packageToScanSecurity = packageToScanSecurity;
        return this;
    }

    public AnterosSecurityManagerBuilder systemName(String systemName) {
        this.systemName = systemName;
        return this;
    }

    public AnterosSecurityManagerBuilder version(String version) {
        this.version = version;
        return this;
    }

    public AnterosSecurityManagerBuilder description(String description) {
        this.description = description;
        return this;
    }

    public AnterosSecurityManager build() throws Exception {
        Assert.notNull((Object)this.systemName, (String)"Para o correto funcionamento da seguran\u00e7a da aplica\u00e7\u00e3o \u00e9 necess\u00e1rio informar o nome do sistema.");
        Assert.notNull((Object)this.version, (String)"Para o correto funcionamento da seguran\u00e7a da aplica\u00e7\u00e3o \u00e9 necess\u00e1rio informar a vers\u00e3o do sistema.");
        Assert.notNull((Object)this.description, (String)"Para o correto funcionamento da seguran\u00e7a da aplica\u00e7\u00e3o \u00e9 necess\u00e1rio informar a descri\u00e7\u00e3o do sistema.");
        AnterosSecurityManager securityManager = new AnterosSecurityManager();
        securityManager.setAdminNeedsPermission(this.adminNeedsPermission);
        securityManager.setPackageToScanSecurity(this.packageToScanSecurity);
        securityManager.setSystemName(this.systemName);
        securityManager.setVersion(this.version);
        securityManager.setDescription(this.description);
        securityManager.afterPropertiesSet();
        return securityManager;
    }
}

