/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.spring.config;

import br.com.anteros.security.spring.AnterosSecurityAccessDecisionManager;
import br.com.anteros.security.spring.AnterosSecurityVoter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AdviceMode;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.access.annotation.Jsr250MethodSecurityMetadataSource;
import org.springframework.security.access.annotation.SecuredAnnotationSecurityMetadataSource;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.ExpressionBasedAnnotationAttributeFactory;
import org.springframework.security.access.expression.method.ExpressionBasedPostInvocationAdvice;
import org.springframework.security.access.expression.method.ExpressionBasedPreInvocationAdvice;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.access.intercept.AfterInvocationManager;
import org.springframework.security.access.intercept.AfterInvocationProviderManager;
import org.springframework.security.access.intercept.RunAsManager;
import org.springframework.security.access.intercept.aopalliance.MethodSecurityInterceptor;
import org.springframework.security.access.intercept.aspectj.AspectJMethodSecurityInterceptor;
import org.springframework.security.access.method.DelegatingMethodSecurityMetadataSource;
import org.springframework.security.access.method.MethodSecurityMetadataSource;
import org.springframework.security.access.prepost.PostInvocationAdviceProvider;
import org.springframework.security.access.prepost.PostInvocationAuthorizationAdvice;
import org.springframework.security.access.prepost.PreInvocationAuthorizationAdvice;
import org.springframework.security.access.prepost.PrePostAnnotationSecurityMetadataSource;
import org.springframework.security.access.prepost.PrePostInvocationAttributeFactory;
import org.springframework.security.authentication.AuthenticationEventPublisher;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.DefaultAuthenticationEventPublisher;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.util.Assert;

@Configuration
@EnableGlobalMethodSecurity(prePostEnabled=true)
public abstract class AbstractSpringGlobalMethodSecurityConfiguration
implements ImportAware,
SmartInitializingSingleton {
    private static final Log logger = LogFactory.getLog(AbstractSpringGlobalMethodSecurityConfiguration.class);
    private ObjectPostProcessor<Object> objectPostProcessor = new ObjectPostProcessor<Object>(){

        public <T> T postProcess(T object) {
            throw new IllegalStateException(ObjectPostProcessor.class.getName() + " is a required bean. Ensure you have used @" + EnableGlobalMethodSecurity.class.getName());
        }
    };
    private DefaultMethodSecurityExpressionHandler defaultMethodExpressionHandler = new DefaultMethodSecurityExpressionHandler();
    private AuthenticationManager authenticationManager;
    private AuthenticationManagerBuilder auth;
    private boolean disableAuthenticationRegistry;
    private AnnotationAttributes enableMethodSecurity;
    private ApplicationContext context;
    private MethodSecurityExpressionHandler expressionHandler;
    private Jsr250MethodSecurityMetadataSource jsr250MethodSecurityMetadataSource;
    private MethodSecurityInterceptor methodSecurityInterceptor;

    @Bean
    public MethodInterceptor methodSecurityInterceptor() throws Exception {
        this.methodSecurityInterceptor = this.isAspectJ() ? new AspectJMethodSecurityInterceptor() : new MethodSecurityInterceptor();
        this.methodSecurityInterceptor.setAccessDecisionManager(this.accessDecisionManager());
        this.methodSecurityInterceptor.setAfterInvocationManager(this.afterInvocationManager());
        this.methodSecurityInterceptor.setSecurityMetadataSource(this.methodSecurityMetadataSource());
        RunAsManager runAsManager = this.runAsManager();
        if (runAsManager != null) {
            this.methodSecurityInterceptor.setRunAsManager(runAsManager);
        }
        return this.methodSecurityInterceptor;
    }

    public void afterSingletonsInstantiated() {
        GrantedAuthorityDefaults grantedAuthorityDefaults;
        AuthenticationTrustResolver trustResolver;
        RoleHierarchy roleHierarchy;
        try {
            this.initializeMethodSecurityInterceptor();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        PermissionEvaluator permissionEvaluator = this.getSingleBeanOrNull(PermissionEvaluator.class);
        if (permissionEvaluator != null) {
            this.defaultMethodExpressionHandler.setPermissionEvaluator(permissionEvaluator);
        }
        if ((roleHierarchy = this.getSingleBeanOrNull(RoleHierarchy.class)) != null) {
            this.defaultMethodExpressionHandler.setRoleHierarchy(roleHierarchy);
        }
        if ((trustResolver = this.getSingleBeanOrNull(AuthenticationTrustResolver.class)) != null) {
            this.defaultMethodExpressionHandler.setTrustResolver(trustResolver);
        }
        if ((grantedAuthorityDefaults = this.getSingleBeanOrNull(GrantedAuthorityDefaults.class)) != null) {
            this.defaultMethodExpressionHandler.setDefaultRolePrefix(grantedAuthorityDefaults.getRolePrefix());
        }
    }

    private <T> T getSingleBeanOrNull(Class<T> type) {
        String[] beanNamesForType = this.context.getBeanNamesForType(type);
        if (beanNamesForType == null || beanNamesForType.length != 1) {
            return null;
        }
        return (T)this.context.getBean(beanNamesForType[0], type);
    }

    private void initializeMethodSecurityInterceptor() throws Exception {
        if (this.methodSecurityInterceptor == null) {
            return;
        }
        this.methodSecurityInterceptor.setAuthenticationManager(this.authenticationManager());
    }

    protected AfterInvocationManager afterInvocationManager() {
        if (this.prePostEnabled()) {
            AfterInvocationProviderManager invocationProviderManager = new AfterInvocationProviderManager();
            ExpressionBasedPostInvocationAdvice postAdvice = new ExpressionBasedPostInvocationAdvice(this.getExpressionHandler());
            PostInvocationAdviceProvider postInvocationAdviceProvider = new PostInvocationAdviceProvider((PostInvocationAuthorizationAdvice)postAdvice);
            ArrayList<PostInvocationAdviceProvider> afterInvocationProviders = new ArrayList<PostInvocationAdviceProvider>();
            afterInvocationProviders.add(postInvocationAdviceProvider);
            invocationProviderManager.setProviders(afterInvocationProviders);
            return invocationProviderManager;
        }
        return null;
    }

    protected RunAsManager runAsManager() {
        return null;
    }

    protected AccessDecisionManager accessDecisionManager() {
        ArrayList<AccessDecisionVoter<? extends Object>> decisionVoters = new ArrayList<AccessDecisionVoter<? extends Object>>();
        decisionVoters.add(new AnterosSecurityVoter());
        AnterosSecurityAccessDecisionManager result = new AnterosSecurityAccessDecisionManager(decisionVoters);
        return result;
    }

    protected MethodSecurityExpressionHandler createExpressionHandler() {
        return this.defaultMethodExpressionHandler;
    }

    protected final MethodSecurityExpressionHandler getExpressionHandler() {
        if (this.expressionHandler == null) {
            this.expressionHandler = this.createExpressionHandler();
        }
        return this.expressionHandler;
    }

    protected MethodSecurityMetadataSource customMethodSecurityMetadataSource() {
        return null;
    }

    protected AuthenticationManager authenticationManager() throws Exception {
        if (this.authenticationManager == null) {
            DefaultAuthenticationEventPublisher eventPublisher = (DefaultAuthenticationEventPublisher)this.objectPostProcessor.postProcess((Object)new DefaultAuthenticationEventPublisher());
            this.auth = new AuthenticationManagerBuilder(this.objectPostProcessor);
            this.auth.authenticationEventPublisher((AuthenticationEventPublisher)eventPublisher);
            this.configure(this.auth);
            this.authenticationManager = this.disableAuthenticationRegistry ? this.getAuthenticationConfiguration().getAuthenticationManager() : (AuthenticationManager)this.auth.build();
        }
        return this.authenticationManager;
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        this.disableAuthenticationRegistry = true;
    }

    @Bean
    public MethodSecurityMetadataSource methodSecurityMetadataSource() {
        ArrayList<Object> sources = new ArrayList<Object>();
        ExpressionBasedAnnotationAttributeFactory attributeFactory = new ExpressionBasedAnnotationAttributeFactory(this.getExpressionHandler());
        MethodSecurityMetadataSource customMethodSecurityMetadataSource = this.customMethodSecurityMetadataSource();
        if (customMethodSecurityMetadataSource != null) {
            sources.add(customMethodSecurityMetadataSource);
        }
        if (this.prePostEnabled()) {
            sources.add(new PrePostAnnotationSecurityMetadataSource((PrePostInvocationAttributeFactory)attributeFactory));
        }
        if (this.securedEnabled()) {
            sources.add(new SecuredAnnotationSecurityMetadataSource());
        }
        if (this.jsr250Enabled()) {
            GrantedAuthorityDefaults grantedAuthorityDefaults = this.getSingleBeanOrNull(GrantedAuthorityDefaults.class);
            if (grantedAuthorityDefaults != null) {
                this.jsr250MethodSecurityMetadataSource.setDefaultRolePrefix(grantedAuthorityDefaults.getRolePrefix());
            }
            sources.add(this.jsr250MethodSecurityMetadataSource);
        }
        return new DelegatingMethodSecurityMetadataSource(sources);
    }

    @Bean
    public PreInvocationAuthorizationAdvice preInvocationAuthorizationAdvice() {
        ExpressionBasedPreInvocationAdvice preInvocationAdvice = new ExpressionBasedPreInvocationAdvice();
        preInvocationAdvice.setExpressionHandler(this.getExpressionHandler());
        return preInvocationAdvice;
    }

    public final void setImportMetadata(AnnotationMetadata importMetadata) {
        Map annotationAttributes = importMetadata.getAnnotationAttributes(EnableGlobalMethodSecurity.class.getName());
        this.enableMethodSecurity = AnnotationAttributes.fromMap((Map)annotationAttributes);
    }

    @Autowired(required=false)
    public void setObjectPostProcessor(ObjectPostProcessor<Object> objectPostProcessor) {
        this.objectPostProcessor = objectPostProcessor;
        this.defaultMethodExpressionHandler = (DefaultMethodSecurityExpressionHandler)objectPostProcessor.postProcess((Object)this.defaultMethodExpressionHandler);
    }

    @Autowired(required=false)
    public void setJsr250MethodSecurityMetadataSource(Jsr250MethodSecurityMetadataSource jsr250MethodSecurityMetadataSource) {
        this.jsr250MethodSecurityMetadataSource = jsr250MethodSecurityMetadataSource;
    }

    @Autowired(required=false)
    public void setMethodSecurityExpressionHandler(List<MethodSecurityExpressionHandler> handlers) {
        if (handlers.size() != 1) {
            logger.debug((Object)("Not autowiring MethodSecurityExpressionHandler since size != 1. Got " + handlers));
            return;
        }
        this.expressionHandler = handlers.get(0);
    }

    @Autowired
    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    private AuthenticationConfiguration getAuthenticationConfiguration() {
        return (AuthenticationConfiguration)this.context.getBean(AuthenticationConfiguration.class);
    }

    private boolean prePostEnabled() {
        return this.enableMethodSecurity().getBoolean("prePostEnabled");
    }

    private boolean securedEnabled() {
        return this.enableMethodSecurity().getBoolean("securedEnabled");
    }

    private boolean jsr250Enabled() {
        return this.enableMethodSecurity().getBoolean("jsr250Enabled");
    }

    private int order() {
        return (Integer)this.enableMethodSecurity().get((Object)"order");
    }

    private boolean isAspectJ() {
        return this.enableMethodSecurity().getEnum("mode") == AdviceMode.ASPECTJ;
    }

    private AnnotationAttributes enableMethodSecurity() {
        if (this.enableMethodSecurity == null) {
            EnableGlobalMethodSecurity methodSecurityAnnotation = (EnableGlobalMethodSecurity)AnnotationUtils.findAnnotation(this.getClass(), EnableGlobalMethodSecurity.class);
            Assert.notNull((Object)methodSecurityAnnotation, (String)(EnableGlobalMethodSecurity.class.getName() + " is required"));
            Map methodSecurityAttrs = AnnotationUtils.getAnnotationAttributes((Annotation)methodSecurityAnnotation);
            this.enableMethodSecurity = AnnotationAttributes.fromMap((Map)methodSecurityAttrs);
        }
        return this.enableMethodSecurity;
    }
}

