/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.spring;

import br.com.anteros.security.spring.AnterosSecurityGrantedAuthority;
import br.com.anteros.security.store.domain.IAction;
import br.com.anteros.security.store.domain.IUser;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class AnterosSecurityUser
implements UserDetails {
    private static final long serialVersionUID = 1L;
    private String userName;
    private String password;
    private String systemName;
    private String version;
    private boolean adminNeedsPermission = true;
    private Set<AnterosSecurityGrantedAuthority> actions;
    private boolean accountExpired;
    private boolean accountLocked;
    private boolean accountInactive;
    private boolean admin;

    public AnterosSecurityUser(IUser user) {
        this.makeUser(user);
        user = null;
    }

    public AnterosSecurityUser(IUser user, String systemName) {
        this.systemName = systemName;
        this.makeUser(user);
        user = null;
    }

    private void makeUser(IUser user) {
        this.userName = user.getLogin();
        this.password = user.getPassword();
        this.accountExpired = user.isPasswordNeverExpire();
        this.accountInactive = user.isInactiveAccount();
        this.accountLocked = user.isBlockedAccount();
        this.admin = user.isAdministrator();
        this.actions = new HashSet<AnterosSecurityGrantedAuthority>();
        for (IAction action : user.getActionList()) {
            if (this.systemName != null && !action.getResource().getSystem().getSystemName().equalsIgnoreCase(this.systemName)) continue;
            this.actions.add(new AnterosSecurityGrantedAuthority(action));
        }
        if (user.getUserProfile() != null) {
            for (IAction action : user.getUserProfile().getActionsList()) {
                if (this.systemName != null && !action.getResource().getSystem().getSystemName().equalsIgnoreCase(this.systemName)) continue;
                this.actions.add(new AnterosSecurityGrantedAuthority(action));
            }
        }
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.actions;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.userName;
    }

    public boolean isAccountNonExpired() {
        return !this.accountExpired;
    }

    public boolean isAccountNonLocked() {
        return !this.accountLocked;
    }

    public boolean isCredentialsNonExpired() {
        return !this.accountExpired;
    }

    public boolean isEnabled() {
        return !this.accountLocked && !this.accountInactive;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isAdminNeedsPermission() {
        return this.adminNeedsPermission;
    }

    public void setAdminNeedsPermission(boolean adminNeedsPermission) {
        this.adminNeedsPermission = adminNeedsPermission;
    }
}

