/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.spring.config;

import br.com.anteros.security.spring.AnterosSecurityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;

@Configuration
@EnableResourceServer
public abstract class AbstractSpringResourceServerConfiguration
extends ResourceServerConfigurerAdapter {
    @Autowired
    private AnterosSecurityManager authenticationManager;

    public void configure(ResourceServerSecurityConfigurer resources) {
        ResourceServerTokenServices tokenServices = this.getResourceServerTokenServicesToAuthentication();
        if (tokenServices != null) {
            resources.tokenServices(tokenServices);
            this.authenticationManager.setTokenServices(tokenServices);
            this.authenticationManager.setResourceId(this.getResourceId());
        }
        resources.resourceId(this.getResourceId());
        resources.authenticationManager((AuthenticationManager)this.authenticationManager);
    }

    public abstract String getResourceId();

    public abstract String getSecuredPattern();

    public abstract ResourceServerTokenServices getResourceServerTokenServicesToAuthentication();

    public void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity.RequestMatcherConfigurer)http.requestMatchers().antMatchers(new String[]{this.getSecuredPattern()})).and().cors().and()).authorizeRequests().anyRequest()).authenticated().and()).csrf().disable();
    }
}

