/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.spring;

import br.com.anteros.core.log.Logger;
import br.com.anteros.core.log.LoggerProvider;
import br.com.anteros.core.scanner.ClassFilter;
import br.com.anteros.core.scanner.ClassPathResourceFilter;
import br.com.anteros.core.scanner.ClassPathScanner;
import br.com.anteros.core.utils.ObjectUtils;
import br.com.anteros.core.utils.ReflectionUtils;
import br.com.anteros.core.utils.StringUtils;
import br.com.anteros.security.spring.ActionSecured;
import br.com.anteros.security.spring.AnterosSecurityAuthenticationToken;
import br.com.anteros.security.spring.AnterosSecurityException;
import br.com.anteros.security.spring.AnterosSecurityOAuth2Authentication;
import br.com.anteros.security.spring.AnterosSecurityUser;
import br.com.anteros.security.spring.ResourceSecured;
import br.com.anteros.security.store.SecurityDataStore;
import br.com.anteros.security.store.domain.IAction;
import br.com.anteros.security.store.domain.IResource;
import br.com.anteros.security.store.domain.ISystem;
import br.com.anteros.security.store.domain.IUser;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.client.resource.OAuth2AccessDeniedException;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.ClientAlreadyExistsException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import org.springframework.security.oauth2.provider.ClientRegistrationService;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.provisioning.UserDetailsManager;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

@Component(value="authenticationManager")
@ComponentScan(value={"br.com.anteros.security.spring"})
public class AnterosSecurityManager
implements AuthenticationProvider,
InitializingBean,
AuthenticationManager,
UserDetailsService,
UserDetailsManager,
ClientRegistrationService,
ClientDetailsService {
    @Autowired
    private PasswordEncoder userPasswordEncoder;
    @Autowired
    private SecurityDataStore securityDataStore;
    protected String packageToScanSecurity;
    protected String systemName;
    protected String description;
    protected String version;
    protected boolean adminNeedsPermission = true;
    private static Logger LOG = LoggerProvider.getInstance().getLogger(AnterosSecurityManager.class.getName());
    private boolean initialized = false;
    private Map<String, AnterosSecurityUser> cacheUsers = new HashMap<String, AnterosSecurityUser>();
    @Autowired
    protected WebApplicationContext context;
    private ResourceServerTokenServices tokenServices;
    private String resourceId;

    public ResourceServerTokenServices getTokenServices() {
        return this.tokenServices;
    }

    public void setTokenServices(ResourceServerTokenServices tokenServices) {
        this.tokenServices = tokenServices;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        IUser userDomain;
        String username = "";
        if (authentication == null) {
            throw new InvalidTokenException("Invalid token (token not found)");
        }
        if (this.tokenServices != null && ObjectUtils.isEmpty((Object)authentication.getCredentials())) {
            IUser userDomain2;
            OAuth2AuthenticationDetails details;
            String token = (String)authentication.getPrincipal();
            OAuth2Authentication auth = this.tokenServices.loadAuthentication(token);
            if (auth == null) {
                throw new InvalidTokenException("Invalid token: " + token);
            }
            Set resourceIds = auth.getOAuth2Request().getResourceIds();
            if (this.resourceId != null && resourceIds != null && !resourceIds.isEmpty() && !resourceIds.contains(this.resourceId)) {
                throw new OAuth2AccessDeniedException("Invalid token does not contain resource id (" + this.resourceId + ")");
            }
            if (authentication.getDetails() instanceof OAuth2AuthenticationDetails && !(details = (OAuth2AuthenticationDetails)authentication.getDetails()).equals(auth.getDetails())) {
                details.setDecodedDetails(auth.getDetails());
            }
            auth.setDetails(authentication.getDetails());
            auth.setAuthenticated(true);
            AnterosSecurityUser user = null;
            username = auth.getPrincipal() instanceof AnterosSecurityUser ? ((AnterosSecurityUser)auth.getPrincipal()).getUsername() : "" + auth.getPrincipal();
            user = this.cacheUsers.get(username);
            if (user == null && (userDomain2 = this.securityDataStore.getUserByUserName(username)) != null) {
                user = new AnterosSecurityUser(userDomain2, this.systemName);
            }
            if (user == null) {
                throw new BadCredentialsException("Username not found.");
            }
            if (authentication.getCredentials() == null) {
                LOG.debug((Object)"Authentication failed: no credentials provided");
                throw new BadCredentialsException("Bad credentials " + user.getUsername());
            }
            user.setSystemName(this.systemName);
            user.setVersion(this.version);
            user.setAdminNeedsPermission(this.adminNeedsPermission);
            Collection<GrantedAuthority> authorities = user.getAuthorities();
            return new AnterosSecurityOAuth2Authentication(user, auth, authorities);
        }
        LOG.debug((Object)("Authenticate user " + authentication));
        username = authentication.getName();
        AnterosSecurityUser user = this.cacheUsers.get(username);
        if (user == null && (userDomain = this.securityDataStore.getUserByUserName(username)) != null) {
            user = new AnterosSecurityUser(userDomain, this.systemName);
        }
        if (user == null) {
            throw new BadCredentialsException("Username not found.");
        }
        if (authentication.getCredentials() == null) {
            LOG.debug((Object)"Authentication failed: no credentials provided");
            throw new BadCredentialsException("Bad credentials " + user.getUsername());
        }
        String presentedPassword = authentication.getCredentials().toString();
        if (!user.getPassword().equals(presentedPassword)) {
            LOG.debug((Object)"Authentication failed: password does not match stored value");
            throw new BadCredentialsException("Bad credentials " + user.getUsername());
        }
        user.setSystemName(this.systemName);
        user.setVersion(this.version);
        user.setAdminNeedsPermission(this.adminNeedsPermission);
        Collection<? extends GrantedAuthority> authorities = user.getAuthorities();
        return new AnterosSecurityAuthenticationToken(user, authentication.getCredentials(), authorities);
    }

    private void checkClientDetails(OAuth2Authentication auth) {
        ClientDetails client;
        try {
            client = this.loadClientByClientId(auth.getOAuth2Request().getClientId());
        }
        catch (ClientRegistrationException e) {
            throw new OAuth2AccessDeniedException("Invalid token contains invalid client id");
        }
        Set allowed = client.getScope();
        for (String scope : auth.getOAuth2Request().getScope()) {
            if (allowed.contains(scope)) continue;
            throw new OAuth2AccessDeniedException("Invalid token contains disallowed scope (" + scope + ") for this client");
        }
    }

    public boolean supports(Class<?> authentication) {
        return true;
    }

    public void configure() throws Exception {
        this.afterPropertiesSet();
    }

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isNotEmpty((String)this.systemName) && StringUtils.isNotEmpty((String)this.version) && StringUtils.isNotEmpty((String)this.packageToScanSecurity) && !this.initialized) {
            this.securityDataStore.initializeCurrentSession();
            this.scanPackages();
            this.initialized = true;
        }
    }

    protected void scanPackages() {
        if (this.packageToScanSecurity != null && !"".equals(this.packageToScanSecurity)) {
            String[] packages = StringUtils.tokenizeToStringArray((String)this.packageToScanSecurity, (String)", ;");
            List scanClasses = ClassPathScanner.scanClasses((ClassPathResourceFilter[])new ClassPathResourceFilter[]{new ClassFilter().packages(packages).annotation(ResourceSecured.class)});
            this.loadSecuredResourcesAndActions(scanClasses);
        }
    }

    protected void loadSecuredResourcesAndActions(List<Class<?>> classes) {
        try {
            IAction action = null;
            IResource resource = null;
            ISystem system = this.securityDataStore.getSystemByName(this.systemName);
            if (system == null) {
                system = this.securityDataStore.addSystem(this.systemName, this.description);
            }
            for (Class<?> cl : classes) {
                Method[] methods;
                if (!cl.isAnnotationPresent(ResourceSecured.class)) continue;
                ResourceSecured resourceSecured = cl.getAnnotation(ResourceSecured.class);
                resource = this.securityDataStore.getResourceByName(this.systemName, resourceSecured.resourceName());
                if (resource == null) {
                    resource = this.securityDataStore.addResource(system, resourceSecured.resourceName(), resourceSecured.description());
                    this.securityDataStore.refreshResource(resource);
                }
                Method[] methodArray = methods = ReflectionUtils.getAllDeclaredMethods(cl);
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (method.isAnnotationPresent(ActionSecured.class)) {
                        boolean found = false;
                        boolean active = false;
                        action = null;
                        ActionSecured actionSecured = method.getAnnotation(ActionSecured.class);
                        for (IAction act : resource.getActionList()) {
                            if (!act.getActionName().equalsIgnoreCase(actionSecured.actionName())) continue;
                            found = true;
                            active = act.isActive();
                            action = act;
                            break;
                        }
                        if (!found) {
                            action = this.securityDataStore.addAction(system, resource, actionSecured.actionName(), actionSecured.category(), actionSecured.description(), this.version);
                            resource.addAction(action);
                        } else if (action != null) {
                            boolean save = false;
                            if (!active) {
                                action.setActive(true);
                                save = true;
                            }
                            if (!action.getCategory().equalsIgnoreCase(actionSecured.category())) {
                                action.setCategory(actionSecured.category());
                                save = true;
                            }
                            if (save) {
                                this.securityDataStore.saveAction(action);
                            }
                        }
                    }
                    ++n2;
                }
                resource = this.securityDataStore.refreshResource(resource);
                for (IAction act : resource.getActionList()) {
                    boolean found = false;
                    Method[] methodArray2 = methods;
                    int n3 = methods.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ActionSecured actionSecured;
                        Method method = methodArray2[n4];
                        if (method.isAnnotationPresent(ActionSecured.class) && (actionSecured = method.getAnnotation(ActionSecured.class)).actionName().equalsIgnoreCase(act.getActionName())) {
                            found = true;
                            break;
                        }
                        ++n4;
                    }
                    if (found || act.getVersion().compareTo(this.version) >= 0) continue;
                    this.securityDataStore.removeActionByAllUsers(act);
                }
            }
        }
        catch (Exception e) {
            throw new AnterosSecurityException(e);
        }
    }

    public String getPackageToScanSecurity() {
        return this.packageToScanSecurity;
    }

    public AnterosSecurityManager setPackageToScanSecurity(String packageToScanSecurity) throws Exception {
        this.packageToScanSecurity = packageToScanSecurity;
        this.configure();
        return this;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public AnterosSecurityManager setSystemName(String systemName) throws Exception {
        this.systemName = systemName;
        this.configure();
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public AnterosSecurityManager setDescription(String description) throws Exception {
        this.description = description;
        this.configure();
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public AnterosSecurityManager setVersion(String version) throws Exception {
        this.version = version;
        this.configure();
        return this;
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.userPasswordEncoder;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.userPasswordEncoder = passwordEncoder;
    }

    public boolean isAdminNeedsPermission() {
        return this.adminNeedsPermission;
    }

    public AnterosSecurityManager setAdminNeedsPermission(boolean adminNeedsPermission) throws Exception {
        this.adminNeedsPermission = adminNeedsPermission;
        return this;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        IUser user = this.securityDataStore.getUserByUserName(username);
        if (user == null) {
            return null;
        }
        return new AnterosSecurityUser(user);
    }

    public UserDetails loadUserByUsername(String username, String systemName) throws UsernameNotFoundException {
        IUser user = this.securityDataStore.getUserByUserName(username);
        if (user == null) {
            return null;
        }
        return new AnterosSecurityUser(user, systemName);
    }

    public void createUser(UserDetails user) {
        throw new RuntimeException("n\u00e3o implementado ainda createUser");
    }

    public void updateUser(UserDetails user) {
        throw new RuntimeException("n\u00e3o implementado ainda updateUser");
    }

    public void deleteUser(String username) {
        throw new RuntimeException("n\u00e3o implementado ainda deleteUser");
    }

    public void changePassword(String oldPassword, String newPassword) {
        throw new RuntimeException("n\u00e3o implementado ainda changePassword");
    }

    public boolean userExists(String username) {
        throw new RuntimeException("n\u00e3o implementado ainda userExists");
    }

    public void addClientDetails(ClientDetails clientDetails) throws ClientAlreadyExistsException {
        this.securityDataStore.addClientDetails(clientDetails);
    }

    public void updateClientDetails(ClientDetails clientDetails) throws NoSuchClientException {
        this.securityDataStore.updateClientDetails(clientDetails);
    }

    public void updateClientSecret(String clientId, String secret) throws NoSuchClientException {
        this.securityDataStore.updateClientSecret(clientId, secret);
    }

    public void removeClientDetails(String clientId) throws NoSuchClientException {
        this.securityDataStore.removeClientDetails(clientId);
    }

    public List<ClientDetails> listClientDetails() {
        return this.securityDataStore.listClientDetails();
    }

    public ClientDetails loadClientByClientId(String clientId) throws ClientRegistrationException {
        return this.securityDataStore.loadClientByClientId(clientId);
    }
}

